/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.product;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import javax.xml.bind.JAXBException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.wso2.maven.p2.beans.product.config.ProductFileConfig;
import org.wso2.maven.p2.utils.P2ApplicationLaunchManager;
import org.wso2.maven.p2.utils.ProductFileUtils;

@Mojo(name="publish-product")
public class PublishProductMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    private URL repositoryURL;
    @Parameter
    private String executable;
    @Parameter
    private File productConfigurationFile;
    @Parameter
    private ProductFileConfig productFileConfig = new ProductFileConfig();
    @Component
    private P2ApplicationLauncher launcher;
    @Parameter(defaultValue="${p2.timeout}")
    private int forkedProcessTimeoutInSeconds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.publishProduct();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", (Exception)e);
        }
    }

    private void publishProduct() throws MojoFailureException, MojoExecutionException, IOException {
        P2ApplicationLaunchManager p2LaunchManager = new P2ApplicationLaunchManager(this.launcher);
        p2LaunchManager.setWorkingDirectory(this.project.getBasedir());
        p2LaunchManager.setApplicationName("org.eclipse.equinox.p2.publisher.ProductPublisher");
        if (this.productConfigurationFile != null) {
            p2LaunchManager.addPublishProductArguments(this.repositoryURL, this.productConfigurationFile, this.executable);
        } else {
            File productFile = Paths.get(ProductFileUtils.getProductFilePath(this.project), new String[0]).toFile();
            if (!productFile.exists()) {
                try {
                    ProductFileUtils.generateProductFile(this.productFileConfig, this.project);
                }
                catch (JAXBException e) {
                    throw new MojoExecutionException("Cannot proceed as there is an error in writing configurations to product file.", (Exception)((Object)e));
                }
            }
            p2LaunchManager.addPublishProductArguments(this.repositoryURL, productFile, this.executable);
        }
        p2LaunchManager.performAction(this.forkedProcessTimeoutInSeconds);
    }
}

