/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.repository;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.p2.utils.BundleUtils;

public class CatFeature {
    private String id;
    private String version;
    private MavenProject project;
    private boolean versionReplaced = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() throws MojoExecutionException {
        if (!this.versionReplaced) {
            this.replaceProjectKeysInVersion(this.project);
        }
        return BundleUtils.getOSGIVersion(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void replaceProjectKeysInVersion(MavenProject project) throws MojoExecutionException {
        if (this.version == null) {
            throw new MojoExecutionException("Could not find the version for featureId: " + this.getId());
        }
        Properties properties = project.getProperties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            this.version = this.version.replaceAll(Pattern.quote("${" + key + "}"), value.toString());
        }));
        this.versionReplaced = true;
    }
}

