/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.repository;

import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.wso2.maven.p2.repository.Bundle;
import org.wso2.maven.p2.repository.Feature;
import org.wso2.maven.p2.repository.RepositoryGenerator;
import org.wso2.maven.p2.repository.RepositoryResourceBundle;

@Mojo(name="generate-repo", defaultPhase=LifecyclePhase.PACKAGE)
public class RepositoryGeneratorMojo
extends AbstractMojo {
    @Parameter
    private String name;
    @Parameter
    private URL targetRepository;
    @Parameter(required=true)
    private List<Feature> features;
    @Parameter
    private List<Bundle> bundles;
    @Parameter
    private List categories;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean archive;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private P2ApplicationLauncher launcher;
    @Parameter(defaultValue="${p2.timeout}")
    private int forkedProcessTimeoutInSeconds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        RepositoryGenerator generator = this.constructRepoGenerator();
        generator.generate();
    }

    private RepositoryGenerator constructRepoGenerator() {
        RepositoryResourceBundle resourceBundle = new RepositoryResourceBundle();
        resourceBundle.setName(this.name);
        resourceBundle.setRepository(this.targetRepository);
        resourceBundle.setFeatureArtifacts(this.features);
        resourceBundle.setBundleArtifacts(this.bundles);
        resourceBundle.setCategories(this.categories);
        resourceBundle.setProject(this.project);
        resourceBundle.setArchive(this.archive);
        resourceBundle.setRepositorySystem(this.repositorySystem);
        resourceBundle.setLocalRepository(this.localRepository);
        resourceBundle.setRemoteRepositories(this.remoteRepositories);
        resourceBundle.setLauncher(this.launcher);
        resourceBundle.setForkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds);
        resourceBundle.setLog(this.getLog());
        return new RepositoryGenerator(resourceBundle);
    }
}

