/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BundleUtils {
    private static final Pattern OSGI_VERSION_PATTERN = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+(\\.[0-9A-Za-z_-]+)?");
    private static final Pattern ONLY_NUMBERS = Pattern.compile("[0-9]+");

    public static String getOSGIVersion(String version) {
        String qualifier;
        String service;
        String minor;
        String major;
        Pattern needToFillZerosPattern;
        Matcher m = OSGI_VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return version;
        }
        String osgiVersion = version;
        Pattern datedSnapshotPattern = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9]))?\\-([0-9]{8}\\.[0-9]{6}\\-[0-9]*)");
        m = datedSnapshotPattern.matcher(osgiVersion);
        if (m.matches()) {
            String major2 = m.group(1);
            String minor2 = m.group(3) != null ? m.group(3) : "0";
            String service2 = m.group(5) != null ? m.group(5) : "0";
            String qualifier2 = m.group(6).replaceAll("-", "_").replaceAll("\\.", "_");
            osgiVersion = major2 + "." + minor2 + "." + service2 + "." + qualifier2;
        }
        osgiVersion = osgiVersion.replaceFirst("-", "\\.");
        m = OSGI_VERSION_PATTERN.matcher(osgiVersion = osgiVersion.replaceAll("-", "_"));
        if (m.matches()) {
            return osgiVersion;
        }
        Pattern dotsInQualifierPattern = Pattern.compile("([0-9])(\\.[0-9])?\\.([0-9A-Za-z_-]+)\\.([0-9A-Za-z_-]+)");
        m = dotsInQualifierPattern.matcher(osgiVersion);
        if (m.matches()) {
            String s1 = m.group(1);
            String s2 = m.group(2);
            String s3 = m.group(3);
            String s4 = m.group(4);
            Matcher qualifierMatcher = ONLY_NUMBERS.matcher(s3);
            if (!qualifierMatcher.matches()) {
                osgiVersion = s1 + s2 + "." + s3 + "_" + s4;
            }
        }
        if ((m = (needToFillZerosPattern = Pattern.compile("([0-9])(\\.([0-9]))?(\\.([0-9A-Za-z_-]+))?")).matcher(osgiVersion)).matches()) {
            major = m.group(1);
            minor = m.group(3);
            service = null;
            qualifier = m.group(5);
            if (qualifier == null) {
                osgiVersion = BundleUtils.getOSGIVersion(major, minor, null, null);
            } else {
                Matcher qualifierMatcher = ONLY_NUMBERS.matcher(qualifier);
                if (qualifierMatcher.matches()) {
                    if (minor == null) {
                        minor = qualifier;
                    } else {
                        service = qualifier;
                    }
                    osgiVersion = BundleUtils.getOSGIVersion(major, minor, service, null);
                } else {
                    osgiVersion = BundleUtils.getOSGIVersion(major, minor, null, qualifier);
                }
            }
        }
        if (!(m = OSGI_VERSION_PATTERN.matcher(osgiVersion)).matches()) {
            major = "0";
            minor = "0";
            service = "0";
            qualifier = osgiVersion.replaceAll("\\.", "_");
            osgiVersion = major + "." + minor + "." + service + "." + qualifier;
        }
        return osgiVersion;
    }

    private static String getOSGIVersion(String major, String minor, String service, String qualifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(major != null ? major : "0");
        sb.append('.');
        sb.append(minor != null ? minor : "0");
        sb.append('.');
        sb.append(service != null ? service : "0");
        if (qualifier != null) {
            sb.append('.');
            sb.append(qualifier);
        }
        return sb.toString();
    }
}

