/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.wso2.maven.p2.beans.CarbonArtifact;
import org.wso2.maven.p2.utils.MavenUtils;

public class DependencyResolver {
    public static List<HashMap<String, CarbonArtifact>> getDependenciesForProject(MavenProject project, RepositorySystem repositorySystem, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws IOException {
        ArrayList<HashMap<String, CarbonArtifact>> results = new ArrayList<HashMap<String, CarbonArtifact>>();
        HashMap<String, CarbonArtifact> bundles = new HashMap<String, CarbonArtifact>();
        HashMap<String, CarbonArtifact> features = new HashMap<String, CarbonArtifact>();
        results.add(bundles);
        results.add(features);
        List dependencies = project.getDependencies();
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            dependencies.addAll(dependencyManagement.getDependencies());
        }
        for (Dependency dependency : dependencies) {
            String key;
            CarbonArtifact carbonArtifact = new CarbonArtifact();
            carbonArtifact.setGroupId(dependency.getGroupId());
            carbonArtifact.setArtifactId(dependency.getArtifactId());
            carbonArtifact.setVersion(dependency.getVersion());
            carbonArtifact.setType(dependency.getType());
            Artifact mavenArtifact = MavenUtils.getResolvedArtifact(carbonArtifact, repositorySystem, remoteRepositories, localRepository);
            carbonArtifact.setArtifact(mavenArtifact);
            if (carbonArtifact.getType().equals("jar")) {
                if (!DependencyResolver.resolveOSGIInfo(carbonArtifact)) continue;
                key = carbonArtifact.getSymbolicName() + "_" + carbonArtifact.getBundleVersion();
                bundles.put(key, carbonArtifact);
                continue;
            }
            key = carbonArtifact.getArtifactId() + "_" + carbonArtifact.getVersion();
            features.put(key, carbonArtifact);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean resolveOSGIInfo(CarbonArtifact artifact) throws IOException {
        String bundleVersionStr = "Bundle-Version";
        String bundleSymbolicNameStr = "Bundle-SymbolicName";
        if (!artifact.getArtifact().getFile().exists()) {
            return false;
        }
        try (JarFile jarFile = new JarFile(artifact.getArtifact().getFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            String bundleSymbolicName = manifest.getMainAttributes().getValue(bundleSymbolicNameStr);
            String bundleVersion = manifest.getMainAttributes().getValue(bundleVersionStr);
            if (bundleSymbolicName == null || bundleVersion == null) {
                boolean bl = false;
                return bl;
            }
            String[] split = bundleSymbolicName.split(";");
            artifact.setSymbolicName(split[0]);
            artifact.setBundleVersion(bundleVersion);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new IOException("Unable to retrieve maven artifact: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), e);
        }
    }
}

