/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.maven.p2.repository.CatFeature;
import org.wso2.maven.p2.repository.Category;
import org.wso2.maven.p2.utils.BundleUtils;

public class P2Utils {
    private static String[] matchList = new String[]{"perfect", "equivalent", "compatible", "greaterOrEqual", "patch", "optional"};

    public static int getLastIndexOfProperties(File p2InfFile) throws IOException {
        int min = -1;
        if (p2InfFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(p2InfFile), "UTF-8");
                 BufferedReader in = new BufferedReader(reader);){
                String line;
                while ((line = in.readLine()) != null) {
                    int index;
                    String[] split = line.split("=");
                    String[] split2 = split[0].split(Pattern.quote("."));
                    if (!split2[0].equalsIgnoreCase("properties") || (index = Integer.parseInt(split2[1])) <= min) continue;
                    min = index;
                }
            }
        }
        return min;
    }

    public static boolean isMatchString(String matchStr) {
        for (String match : matchList) {
            if (!matchStr.equalsIgnoreCase(match)) continue;
            return true;
        }
        return false;
    }

    public static String getMatchRule(String matchStr) {
        if (P2Utils.isPatch(matchStr)) {
            return "perfect";
        }
        for (String match : matchList) {
            if (!matchStr.equalsIgnoreCase(match)) continue;
            return match;
        }
        return null;
    }

    public static boolean isPatch(String matchStr) {
        return matchStr.equalsIgnoreCase("patch");
    }

    public static void createCategoryFile(MavenProject project, List categories, File categoryFile) throws ParserConfigurationException, TransformerException, MojoExecutionException {
        HashMap<String, ArrayList> featureCategories = new HashMap<String, ArrayList>();
        Document doc = P2Utils.getManifestDocument();
        Element rootElement = doc.getDocumentElement();
        if (rootElement == null) {
            rootElement = doc.createElement("site");
            doc.appendChild(rootElement);
        }
        for (Object e : categories) {
            if (!(e instanceof Category)) continue;
            Category cat = (Category)e;
            Element categoryDef = doc.createElement("category-def");
            categoryDef.setAttribute("name", cat.getId());
            categoryDef.setAttribute("label", cat.getLabel());
            rootElement.appendChild(categoryDef);
            Element descriptionElement = doc.createElement("description");
            descriptionElement.setTextContent(cat.getDescription());
            categoryDef.appendChild(descriptionElement);
            ArrayList<CatFeature> processedFeatures = cat.getProcessedFeatures(project);
            for (CatFeature feature : processedFeatures) {
                ArrayList list;
                if (!featureCategories.containsKey(feature.getId() + feature.getVersion())) {
                    list = new ArrayList();
                    featureCategories.put(feature.getId() + feature.getVersion(), list);
                    list.add(feature);
                }
                list = (ArrayList)featureCategories.get(feature.getId() + feature.getVersion());
                list.add(cat.getId());
            }
        }
        for (Object object : featureCategories.entrySet()) {
            if (!(object instanceof List)) continue;
            List list = (List)object;
            CatFeature feature = (CatFeature)list.get(0);
            list.remove(0);
            Element featureDef = doc.createElement("feature");
            featureDef.setAttribute("id", feature.getId());
            featureDef.setAttribute("version", BundleUtils.getOSGIVersion(feature.getVersion()));
            for (Object catId : list) {
                Element category = doc.createElement("category");
                category.setAttribute("name", catId.toString());
                featureDef.appendChild(category);
            }
            rootElement.appendChild(featureDef);
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(categoryFile);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerConfigurationException("Unable to create feature manifest", e);
        }
        catch (TransformerException e) {
            throw new TransformerException("Unable to create feature manifest", e);
        }
    }

    public static Document getManifestDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }
}

