/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.p2.beans.product.Configurations;
import org.wso2.maven.p2.beans.product.Product;
import org.wso2.maven.p2.beans.product.config.ProductConfig;
import org.wso2.maven.p2.beans.product.config.ProductFileConfig;
import org.wso2.maven.p2.utils.P2Constants;

public class ProductFileUtils {
    public static void generateProductFile(ProductFileConfig productFileConfig, MavenProject mavenProject) throws JAXBException, MojoExecutionException, IOException {
        ProductConfig validatedProductConfig = ProductFileUtils.validateProductConfig(productFileConfig.getProductConfig(), mavenProject);
        Product product = new Product();
        product.setName(validatedProductConfig.getName());
        product.setUid(validatedProductConfig.getUid());
        product.setId(validatedProductConfig.getId());
        product.setApplication(validatedProductConfig.getApplication());
        product.setVersion(ProductFileUtils.validateProductVersion(validatedProductConfig.getVersion()));
        product.setIncludeLaunchers(validatedProductConfig.getIncludeLaunchers());
        product.setConfigIni(validatedProductConfig.getConfigIni());
        product.setLauncher(validatedProductConfig.getLauncher());
        product.setConfigurations(new Configurations(validatedProductConfig.getPluginConfig(), validatedProductConfig.getPropertyConfig()));
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("<?xml version=\"").append(P2Constants.ProductFile.XML_VERSION.toString()).append("\" encoding=\"").append("UTF-8").append("\"?>").append(System.lineSeparator()).append("<?pde version=\"").append(productFileConfig.getPdeVersion().toString()).append("\"?>").append(System.lineSeparator());
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Product.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.fragment", (Object)true);
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)product, (Writer)stringWriter);
        Files.write(Paths.get(ProductFileUtils.getProductFilePath(mavenProject), new String[0]), stringWriter.toString().getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
    }

    public static String getProductFilePath(MavenProject mavenProject) throws MojoExecutionException {
        if (mavenProject == null) {
            throw new MojoExecutionException("Unable to read maven project for finding project path.");
        }
        return mavenProject.getBasedir().getAbsolutePath() + File.separator + "target" + File.separator + "carbon.product";
    }

    private static ProductConfig validateProductConfig(ProductConfig productConfig, MavenProject mavenProject) throws MojoExecutionException {
        if (productConfig.getVersion() == null) {
            productConfig.setVersion(ProductFileUtils.getDependencyVersion(mavenProject, "org.wso2.carbon.osgi"));
        }
        return productConfig;
    }

    private static String validateProductVersion(String version) {
        if (version != null && !version.isEmpty() && version.contains("-")) {
            version = version.replaceAll("-", ".");
        }
        return version;
    }

    private static String getDependencyVersion(MavenProject mavenProject, String dependency) throws MojoExecutionException {
        if (mavenProject == null) {
            throw new MojoExecutionException("Unable to read maven project for finding dependencies.");
        }
        if (dependency == null || dependency.isEmpty()) {
            throw new MojoExecutionException("Unable to find version for invalid dependency value.");
        }
        Artifact selectedArtifact = mavenProject.getDependencyArtifacts().stream().filter(artifact -> artifact.getArtifactId().contains(dependency)).findFirst().orElseThrow(() -> new MojoExecutionException("Unable to find version as there seems to be no pom based configuration for the provided dependency."));
        String dependencyVersion = selectedArtifact.getBaseVersion();
        if (dependencyVersion == null || dependencyVersion.isEmpty()) {
            throw new MojoExecutionException("Unable to find version for the provided dependency.");
        }
        return dependencyVersion;
    }
}

