/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.util.Properties;

public class PropertyReplacer {
    public static String replaceProperties(String origString, Properties props) {
        char[] chars = origString.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean properties = false;
        State state = State.NORMAL;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != State.WITHIN_BRACKET) {
                state = State.SEEN_DOLLAR;
                continue;
            }
            if (c == '{' && state == State.SEEN_DOLLAR) {
                buffer.append(origString.substring(start, i - 1));
                state = State.WITHIN_BRACKET;
                start = i - 1;
                continue;
            }
            if (state == State.SEEN_DOLLAR) {
                state = State.NORMAL;
                continue;
            }
            if (c != '}' || state != State.WITHIN_BRACKET) continue;
            String key = origString.substring(start + 2, i);
            String value = props.getProperty(key);
            if (value != null) {
                properties = true;
                buffer.append(value);
            } else {
                buffer.append("${");
                buffer.append(key);
                buffer.append('}');
            }
            start = i + 1;
            state = State.NORMAL;
        }
        if (!properties) {
            return origString;
        }
        if (start != chars.length) {
            buffer.append(origString.substring(start, chars.length));
        }
        return buffer.toString();
    }

    private static enum State {
        NORMAL,
        SEEN_DOLLAR,
        WITHIN_BRACKET;

    }
}

