/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.profile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import javax.xml.bind.JAXBException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.eclipse.tycho.model.ProductConfiguration;
import org.wso2.maven.p2.beans.product.config.ProductFileConfig;
import org.wso2.maven.p2.utils.FileManagementUtil;
import org.wso2.maven.p2.utils.P2ApplicationLaunchManager;
import org.wso2.maven.p2.utils.ProductFileUtils;

@Mojo(name="generate-runtime")
public class GenerateProfileMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    private URL repositoryURL;
    @Parameter(defaultValue="${productConfiguration}")
    private File productConfigurationFile;
    @Parameter
    private ProductFileConfig productFileConfig = new ProductFileConfig();
    @Parameter
    private URL targetPath;
    @Parameter(defaultValue="${profile}")
    private String runtime;
    @Component
    private P2ApplicationLauncher launcher;
    @Parameter(defaultValue="${p2.timeout}")
    private int forkedProcessTimeoutInSeconds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.runtime == null) {
                this.runtime = "WSO2CarbonProfile";
            }
            this.deployRepository();
            File profileConfigIni = FileManagementUtil.getProfileConfigIniFile(this.targetPath.getPath(), this.runtime);
            FileManagementUtil.changeConfigIniProperty(profileConfigIni, "eclipse.p2.data.area", "@config.dir/../lib/p2/", this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void deployRepository() throws MojoFailureException, MojoExecutionException, IOException {
        ProductConfiguration productConfiguration;
        if (this.productConfigurationFile != null) {
            productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
        } else {
            File productFile = Paths.get(ProductFileUtils.getProductFilePath(this.project), new String[0]).toFile();
            if (!productFile.exists()) {
                try {
                    ProductFileUtils.generateProductFile(this.productFileConfig, this.project);
                }
                catch (JAXBException e) {
                    throw new MojoExecutionException("Cannot proceed as there is an error in writing configurations to product file.", (Exception)((Object)e));
                }
            }
            productConfiguration = ProductConfiguration.read((File)productFile);
        }
        P2ApplicationLaunchManager p2LaunchManager = new P2ApplicationLaunchManager(this.launcher);
        p2LaunchManager.setWorkingDirectory(this.project.getBasedir());
        p2LaunchManager.setApplicationName("org.eclipse.equinox.p2.director");
        p2LaunchManager.addGenerateProfileArguments(this.repositoryURL, productConfiguration.getId(), this.runtime, this.targetPath);
        p2LaunchManager.performAction(this.forkedProcessTimeoutInSeconds);
    }
}

