/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.repository;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.wso2.maven.p2.beans.CarbonArtifact;
import org.wso2.maven.p2.exceptions.CarbonArtifactNotFoundException;
import org.wso2.maven.p2.repository.Bundle;
import org.wso2.maven.p2.repository.Feature;
import org.wso2.maven.p2.repository.RepositoryResourceBundle;
import org.wso2.maven.p2.utils.DependencyResolver;
import org.wso2.maven.p2.utils.FileManagementUtil;
import org.wso2.maven.p2.utils.P2ApplicationLaunchManager;
import org.wso2.maven.p2.utils.P2Utils;

public class RepositoryGenerator {
    private final RepositoryResourceBundle resourceBundle;
    private final MavenProject project;
    private File tempDir;
    private File sourceDir;
    private File repoGenerationLocation;
    private File archiveFile;
    private File categoryDefinitionFile;
    private Log log;
    private static final String PUBLISHER_APPLICATION = "org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher";
    private static final String CATEGORY_PUBLISHER_APPLICATION = "org.eclipse.equinox.p2.publisher.CategoryPublisher";
    private P2ApplicationLaunchManager p2LaunchManager;
    private HashMap<String, CarbonArtifact> dependentBundles;
    private HashMap<String, CarbonArtifact> dependentFeatures;

    public RepositoryGenerator(RepositoryResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.log = resourceBundle.getLog();
        this.project = this.resourceBundle.getProject();
        this.p2LaunchManager = new P2ApplicationLaunchManager(resourceBundle.getLauncher());
    }

    public void generate() throws MojoExecutionException, MojoFailureException {
        try {
            this.resolveDependencies();
            this.populateRequiredArtifactData();
            this.setupTempOutputFolderStructure();
            this.unzipFeaturesToOutputFolder();
            this.copyBundleArtifactsToOutputFolder();
            this.copyProjectResourcesToOutputFolder();
            this.generateRepository();
            this.updateRepositoryWithCategories();
            this.archiveGeneratedRepo();
            this.performMopUp();
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (CarbonArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void resolveDependencies() throws IOException {
        this.log.info((CharSequence)"Inspecting maven dependencies.");
        List<HashMap<String, CarbonArtifact>> artifacts = DependencyResolver.getDependenciesForProject(this.project, this.resourceBundle.getRepositorySystem(), this.resourceBundle.getRemoteRepositories(), this.resourceBundle.getLocalRepository());
        this.dependentBundles = artifacts.get(0);
        this.dependentFeatures = artifacts.get(1);
    }

    private void populateRequiredArtifactData() throws CarbonArtifactNotFoundException {
        this.populateBundleDataFromCache();
        this.populateFeatureDataFromCache();
    }

    private void populateBundleDataFromCache() throws CarbonArtifactNotFoundException {
        for (Bundle bundle : this.resourceBundle.getBundleArtifacts()) {
            String key = bundle.getSymbolicName() + "_" + bundle.getVersion();
            CarbonArtifact artifact = this.dependentBundles.get(key);
            if (artifact == null) {
                throw new CarbonArtifactNotFoundException("Bundle not found");
            }
            artifact.copyTo(bundle);
        }
    }

    private void populateFeatureDataFromCache() throws CarbonArtifactNotFoundException {
        for (Feature feature : this.resourceBundle.getFeatureArtifacts()) {
            String key = feature.getId() + "_" + feature.getVersion();
            CarbonArtifact artifact = this.dependentFeatures.get(key);
            if (artifact == null) {
                throw new CarbonArtifactNotFoundException("Feature " + key + " not found");
            }
            artifact.copyTo(feature);
            feature.setId(artifact.getArtifactId());
        }
    }

    private void copyProjectResourcesToOutputFolder() throws IOException {
        List resources = this.project.getResources();
        if (resources != null) {
            this.log.info((CharSequence)"Copying resources");
            for (Resource resource : resources) {
                try {
                    File resourceFolder = new File(resource.getDirectory());
                    if (!resourceFolder.exists()) continue;
                    this.log.info((CharSequence)("   " + resource.getDirectory()));
                    FileManagementUtil.copyDirectory(resourceFolder, this.repoGenerationLocation);
                }
                catch (IOException e) {
                    throw new IOException("Unable copy resources: " + resource.getDirectory(), e);
                }
            }
        }
    }

    private void generateRepository() throws MojoFailureException {
        this.log.info((CharSequence)"Running Equinox P2 Publisher Application for Repository Generation");
        this.p2LaunchManager.setWorkingDirectory(this.project.getBasedir());
        this.p2LaunchManager.setApplicationName(PUBLISHER_APPLICATION);
        this.p2LaunchManager.addRepoGenerationArguments(this.sourceDir.getAbsolutePath(), this.resourceBundle.getRepository().toString(), this.getRepositoryName());
        this.p2LaunchManager.performAction(this.resourceBundle.getForkedProcessTimeoutInSeconds());
        this.log.info((CharSequence)"Completed running Equinox P2 Publisher Application for Repository Generation");
    }

    private void unzipFeaturesToOutputFolder() throws IOException {
        List<Feature> artifacts = this.resourceBundle.getFeatureArtifacts();
        for (Feature feature : artifacts) {
            try {
                this.log.info((CharSequence)("Extracting feature " + feature.getGroupId() + ":" + feature.getArtifactId()));
                FileManagementUtil.unzip(feature.getArtifact().getFile(), this.sourceDir);
            }
            catch (IOException e) {
                throw new IOException("Error occurred when extracting the Feature Artifact: " + feature.toString(), e);
            }
        }
    }

    private void copyBundleArtifactsToOutputFolder() throws IOException {
        List<Bundle> bundles = this.resourceBundle.getBundleArtifacts();
        if (bundles.size() > 0) {
            this.log.info((CharSequence)"Copying bundle artifacts.");
        }
        File pluginsDir = new File(this.sourceDir, "plugins");
        for (Bundle bundleArtifact : bundles) {
            try {
                this.log.info((CharSequence)("Copying bundle artifact:" + bundleArtifact.getSymbolicName()));
                File file = bundleArtifact.getArtifact().getFile();
                FileManagementUtil.copy(file, new File(pluginsDir, file.getName()));
            }
            catch (IOException e) {
                throw new IOException("Error occurred when extracting the Feature Artifact: " + bundleArtifact.toString(), e);
            }
        }
    }

    private void archiveGeneratedRepo() throws MojoExecutionException {
        if (this.resourceBundle.isArchive()) {
            this.log.info((CharSequence)"Generating repository archive...");
            FileManagementUtil.zipFolder(this.repoGenerationLocation.toString(), this.archiveFile.toString(), this.resourceBundle.getLog());
            this.log.info((CharSequence)("Repository Archive: " + this.archiveFile.toString()));
            try {
                FileManagementUtil.deleteDirectories(this.repoGenerationLocation);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to delete " + this.repoGenerationLocation.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private void setupTempOutputFolderStructure() throws IOException {
        try {
            File targetDir = new File(this.project.getBasedir(), "target");
            String timestampVal = String.valueOf(new Date().getTime());
            this.tempDir = new File(targetDir, "tmp." + timestampVal);
            this.sourceDir = new File(this.tempDir, "featureExtract");
            if (!this.sourceDir.mkdirs()) {
                throw new IOException("Error occurred while creating output folder structure");
            }
            if (this.resourceBundle.getRepository() == null) {
                File repo = new File(targetDir, this.project.getArtifactId() + "_" + this.project.getVersion());
                this.resourceBundle.setRepository(repo.toURI().toURL());
            }
            this.repoGenerationLocation = new File(this.resourceBundle.getRepository().getFile().replace("/", File.separator));
            this.archiveFile = new File(targetDir, this.project.getArtifactId() + "_" + this.project.getVersion() + ".zip");
            this.categoryDefinitionFile = File.createTempFile("equinox-p2", "category");
        }
        catch (IOException e) {
            throw new IOException("Error occurred while creating output folder structure", e);
        }
    }

    private void updateRepositoryWithCategories() throws TransformerException, ParserConfigurationException, MojoExecutionException, MojoFailureException {
        boolean isCategoriesAvailable;
        boolean bl = isCategoriesAvailable = this.resourceBundle.getCategories() != null && this.resourceBundle.getCategories().size() != 0;
        if (isCategoriesAvailable) {
            this.log.info((CharSequence)"Running Equinox P2 Category Publisher Application for the Generated Repository");
            P2Utils.createCategoryFile(this.project, this.resourceBundle.getCategories(), this.categoryDefinitionFile);
            this.p2LaunchManager.setWorkingDirectory(this.project.getBasedir());
            this.p2LaunchManager.setApplicationName(CATEGORY_PUBLISHER_APPLICATION);
            this.p2LaunchManager.addUpdateRepoWithCategoryArguments(this.resourceBundle.getRepository().toString(), this.categoryDefinitionFile.toURI().toString());
            this.p2LaunchManager.performAction(this.resourceBundle.getForkedProcessTimeoutInSeconds());
            this.log.info((CharSequence)"Completed running Equinox P2 Category Publisher Application for the Generated Repository");
        }
    }

    private void performMopUp() {
        try {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (Exception e) {
            this.log.warn((Throwable)new MojoExecutionException("Unable complete mop up operation", e));
        }
    }

    public String getRepositoryName() {
        if (this.resourceBundle.getName() == null) {
            return this.project.getArtifactId();
        }
        return this.resourceBundle.getName();
    }
}

