/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.logging.Log;

public class FileManagementUtil {
    private static final int BUFFER = 2048;

    public static File getProfileConfigIniFile(String destination, String profile) {
        return Paths.get(destination, profile, "configuration", "config.ini").toFile();
    }

    public static void changeConfigIniProperty(File configIniFile, String propKey, String value, Log log) {
        Properties prop = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configIniFile);){
            prop.load(inputStream);
            prop.setProperty(propKey, value);
            try (FileOutputStream outputStream = new FileOutputStream(configIniFile);){
                prop.store(outputStream, null);
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Error occurred while updating " + configIniFile.getName()), (Throwable)e);
        }
    }

    public static void zipFolder(String srcFolder, String destZipFile, Log log) {
        try (FileOutputStream fileWriter = new FileOutputStream(destZipFile);
             ZipOutputStream zip = new ZipOutputStream(fileWriter);){
            FileManagementUtil.addFolderContentsToZip(srcFolder, zip, log);
        }
        catch (IOException e) {
            log.warn((CharSequence)("Error occurred while archiving " + srcFolder), (Throwable)e);
        }
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zip, Log log) {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileManagementUtil.addFolderToZip(path, srcFile, zip, log);
        } else {
            byte[] buf = new byte[1024];
            try (FileInputStream inputStream = new FileInputStream(srcFile);){
                int len;
                if (path.trim().equals("")) {
                    zip.putNextEntry(new ZipEntry(folder.getName()));
                } else {
                    zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
                }
                while ((len = inputStream.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                log.warn((CharSequence)("Error occurred while archiving " + srcFile), (Throwable)e);
            }
        }
    }

    private static void addFolderContentsToZip(String srcFolder, ZipOutputStream zip, Log log) {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList != null) {
            try {
                for (int i = 0; fileList.length != i; ++i) {
                    if (new File(folder, fileList[i]).isDirectory()) {
                        zip.putNextEntry(new ZipEntry(fileList[i] + "/"));
                        zip.closeEntry();
                    }
                    FileManagementUtil.addToZip("", srcFolder + "/" + fileList[i], zip, log);
                }
            }
            catch (IOException e) {
                log.warn((CharSequence)("Error occurred while archiving " + srcFolder), (Throwable)e);
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip, Log log) {
        File folder = new File(srcFolder);
        String[] fileList = folder.list();
        if (fileList != null) {
            try {
                for (int i = 0; fileList.length != i; ++i) {
                    String newPath = folder.getName();
                    if (!path.equalsIgnoreCase("")) {
                        newPath = path + "/" + newPath;
                    }
                    if (new File(folder, fileList[i]).isDirectory()) {
                        zip.putNextEntry(new ZipEntry(newPath + "/" + fileList[i] + "/"));
                        zip.closeEntry();
                    }
                    FileManagementUtil.addToZip(newPath, srcFolder + "/" + fileList[i], zip, log);
                }
            }
            catch (IOException e) {
                log.warn((CharSequence)("Error occurred while archiving " + srcFolder), (Throwable)e);
            }
        }
    }

    public static void deleteDirectories(File dir) throws IOException {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child == null) continue;
                String[] childrenOfChild = child.list();
                if (childrenOfChild != null) {
                    if (childrenOfChild.length > 0) {
                        FileManagementUtil.deleteDirectories(child);
                        continue;
                    }
                    if (child.delete()) continue;
                    throw new IOException("Failed to delete " + child.getAbsolutePath());
                }
                if (child.delete()) continue;
                throw new IOException("Failed to delete " + child.getAbsolutePath());
            }
            if (!dir.delete()) {
                throw new IOException("Failed to delete " + dir.getAbsolutePath());
            }
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                throw new IOException("Failed to create directory " + dstDir.getAbsolutePath());
            }
            String[] children = srcDir.list();
            if (children != null) {
                for (String child : children) {
                    FileManagementUtil.copyDirectory(new File(srcDir, child), new File(dstDir, child));
                }
            }
        } else {
            FileManagementUtil.copy(srcDir, dstDir);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (dst.getParentFile() != null && !dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
            throw new IOException("Failed to create " + dst.getAbsolutePath());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File archiveFile, File destination) throws IOException {
        try (FileInputStream fis = new FileInputStream(archiveFile);
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                FileOutputStream fos;
                block50: {
                    byte[] data = new byte[2048];
                    File file = new File(destination, entry.getName());
                    if (entry.getName().endsWith("/")) {
                        if (file.exists() || file.mkdirs()) continue;
                        throw new IOException("Failed to create directories at " + file.getAbsolutePath());
                    }
                    if (!(file.getParentFile() == null || file.getParentFile().exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                        throw new IOException("Failed to create directories at " + file.getAbsolutePath());
                    }
                    fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                            int count;
                            while ((count = zis.read(data, 0, 2048)) != -1) {
                                dest.write(data, 0, count);
                            }
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block50;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }
}

