/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

public class P2ApplicationLaunchManager {
    private final P2ApplicationLauncher launcher;

    public P2ApplicationLaunchManager(P2ApplicationLauncher launcher) {
        this.launcher = launcher;
    }

    public void setWorkingDirectory(File workingDir) {
        this.launcher.setWorkingDirectory(workingDir);
    }

    public void setApplicationName(String applicationName) {
        this.launcher.setApplicationName(applicationName);
    }

    public void addArgumentsToInstallFeatures(String repositoryLocation, String installIUs, String destination, String profile) {
        this.launcher.addArguments(new String[]{"-metadataRepository", repositoryLocation, "-artifactRepository", repositoryLocation, "-profileProperties", "org.eclipse.update.install.features=true", "-installIU", installIUs, "-bundlepool", Paths.get(destination, "lib").toString(), "-shared", Paths.get(destination, "lib", "p2").toString(), "-destination", Paths.get(destination, profile).toString(), "-profile", profile, "-roaming"});
    }

    public void addArgumentsToUnInstallFeatures(String uninstallIUs, String destination, String profile) {
        this.launcher.addArguments(new String[]{"-profileProperties", "org.eclipse.update.install.features=false", "-uninstallIU", uninstallIUs, "-shared", Paths.get(destination, "lib", "p2").toString(), "-destination", Paths.get(destination, profile).toString(), "-profile", profile});
    }

    public void addRepoGenerationArguments(String sourceDir, String metadataRepoLocation, String repositoryName) {
        this.launcher.addArguments(new String[]{"-source", sourceDir, "-metadataRepository", metadataRepoLocation, "-metadataRepositoryName", repositoryName, "-artifactRepository", metadataRepoLocation, "-artifactRepositoryName", repositoryName, "-publishArtifacts", "-publishArtifactRepository", "-compress", "-append"});
    }

    public void addUpdateRepoWithCategoryArguments(String metadataRepositoryLocation, String categoryDefinitionFile) {
        this.launcher.addArguments(new String[]{"-metadataRepository", metadataRepositoryLocation, "-categoryDefinition", categoryDefinitionFile, "-categoryQualifier", "-compress", "-append"});
    }

    public void addPublishProductArguments(URL repositoryURL, File productConfigurationFile, String executable) throws IOException {
        this.launcher.addArguments(new String[]{"-metadataRepository", repositoryURL.toString(), "-artifactRepository", repositoryURL.toString(), "-productFile", productConfigurationFile.getCanonicalPath(), "-executables", executable, "-publishArtifacts", "-configs", "gtk.linux.x86", "-flavor", "tooling", "-append"});
    }

    public void addGenerateProfileArguments(URL repositoryURL, String id, String profile, URL targetPath) {
        this.launcher.addArguments(new String[]{"-metadataRepository", repositoryURL.toExternalForm(), "-artifactRepository", repositoryURL.toExternalForm(), "-installIU", id, "-profileProperties", "org.eclipse.update.install.features=true", "-profile", profile, "-bundlepool", targetPath.toExternalForm() + File.separator + "lib", "-shared", targetPath.toExternalForm() + File.separator + "lib" + File.separator + "p2", "-destination", targetPath.toExternalForm() + File.separator + profile, "-p2.os", "linux", "-p2.ws", "gtk", "-p2.arch", "x86", "-roaming"});
    }

    public void performAction(int forkedProcessTimeoutInSeconds) throws MojoFailureException {
        int result = this.launcher.execute(forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }
}

