/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.utils;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.internal.EquinoxInstallationLaunchConfiguration;
import org.eclipse.tycho.launching.LaunchConfiguration;

public class StandaloneManager {
    private final EquinoxLauncher launcher;
    private File runtimeLocation;
    private List<String> programArguments;

    public StandaloneManager(EquinoxLauncher launcher) {
        this.launcher = launcher;
        this.programArguments = new ArrayList<String>();
    }

    public void setRuntimeLocation(File runtimeLocation) {
        this.runtimeLocation = runtimeLocation;
    }

    public void addArgumentsToInstallFeatures(String repositoryLocation, String destination, String profile) {
        this.programArguments.add("-metadataRepository");
        this.programArguments.add(repositoryLocation);
        this.programArguments.add("-artifactRepository");
        this.programArguments.add(repositoryLocation);
        this.programArguments.add("-destination");
        this.programArguments.add(Paths.get(destination, profile).toString());
        this.programArguments.add("-bundlepool");
        this.programArguments.add(Paths.get(destination, "lib").toString());
        this.programArguments.add("-shared");
        this.programArguments.add(Paths.get(destination, "lib", "p2").toString());
        this.programArguments.add("-profile");
        this.programArguments.add(profile);
        this.programArguments.add("-profileProperties");
        this.programArguments.add("org.eclipse.update.install.features=true");
        this.programArguments.add("-roaming");
    }

    public void performAction(String installIU, int forkedProcessTimeoutInSeconds) throws MojoFailureException {
        int index = this.programArguments.indexOf("-installIU");
        if (index >= 0) {
            this.programArguments.set(index + 1, installIU);
        } else {
            this.programArguments.add("-installIU");
            this.programArguments.add(installIU);
        }
        EquinoxInstallationLaunchConfiguration launch = new EquinoxInstallationLaunchConfiguration(this.runtimeLocation, this.programArguments);
        int result = this.launcher.execute((LaunchConfiguration)launch, forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }
}

