/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.config.XMLBasedConfigProvider;
import org.wso2.carbon.kernel.internal.context.CarbonRuntimeFactory;
import org.wso2.carbon.kernel.internal.logging.LoggingConfiguration;

@Component(name="org.wso2.carbon.kernel.internal.CarbonCoreDSComponent", immediate=true)
public class CarbonCoreDSComponent {
    private static final Logger logger = LoggerFactory.getLogger(LoggingConfiguration.class);
    private LoggingConfiguration loggingConfiguration = LoggingConfiguration.getInstance();

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        DataHolder.getInstance().setBundleContext(bundleContext);
        XMLBasedConfigProvider configProvider = new XMLBasedConfigProvider();
        CarbonRuntime carbonRuntime = CarbonRuntimeFactory.createCarbonRuntime(configProvider);
        bundleContext.registerService(CarbonRuntime.class.getName(), (Object)carbonRuntime, null);
    }

    @Deactivate
    protected void stop() throws Exception {
        DataHolder.getInstance().setBundleContext(null);
    }

    @Reference(name="config.admin.managed.service", service=ManagedService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterLoggingConfig")
    protected void registerLoggingConfig(ManagedService managedService, Map<String, ?> properties) {
        String pid = (String)properties.get("service.pid");
        if (pid == null || !"org.ops4j.pax.logging".equals(pid)) {
            return;
        }
        try {
            this.loggingConfiguration.register(managedService);
        }
        catch (Throwable e) {
            logger.error("Cannot load logging configuration", e);
        }
    }

    protected void unRegisterLoggingConfig(ManagedService managedService) {
        this.loggingConfiguration.unregister(managedService);
    }
}

