/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.command;

import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.kernel.CarbonRuntime;

@Component(name="org.wso2.carbon.kernel.internal.command.CarbonKernelCommandProvider", immediate=true)
public class CarbonKernelCommandProvider
implements CommandProvider {
    private CarbonRuntime carbonRuntime;
    private ServiceRegistration<CommandProvider> serviceRegistration;

    @Activate
    public void registerCommandProvider(BundleContext bundleContext) {
        this.serviceRegistration = bundleContext.registerService(CommandProvider.class, (Object)this, null);
    }

    @Deactivate
    public void unregisterCommandProvider(BundleContext bundleContext) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    public void unsetCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = null;
    }

    public CarbonRuntime getCarbonRuntime() throws Exception {
        if (this.carbonRuntime == null) {
            throw new Exception("CarbonRuntime instance is not available");
        }
        return this.carbonRuntime;
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonRuntime")
    public void setCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = carbonRuntime;
    }

    public String getHelp() {
        return "---Tenants---\n\taddTenant <domain> <name> <description> <admin username> <admin email address> - Adds a tenant\n\t\t<domain> - tenant domain\n\t\t<name> - tenant name\n\t\t<description> - tenant description\n\t\t<admin username> - Administrator's username\n\t\t<admin email address> - Administrator's email address\n\tgetTenantInfo <domain> - Retrieve tenant data\n\t\t<domain> - Tenant domain\n";
    }
}

