/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.config.CarbonConfigProvider;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.utils.Utils;

public class XMLBasedConfigProvider
implements CarbonConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(XMLBasedConfigProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CarbonConfiguration getCarbonConfiguration() {
        String configFileLocation = Utils.getCarbonXMLLocation();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(configFileLocation), StandardCharsets.ISO_8859_1);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CarbonConfiguration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setListener(new Unmarshaller.Listener(){

                public void beforeUnmarshal(Object target, Object parent) {
                    super.beforeUnmarshal(target, parent);
                }

                public void afterUnmarshal(Object target, Object parent) {
                    super.afterUnmarshal(target, parent);
                }
            });
            CarbonConfiguration carbonConfiguration = (CarbonConfiguration)unmarshaller.unmarshal((Reader)in);
            return carbonConfiguration;
        }
        catch (IOException | JAXBException e) {
            logger.error("Could not load " + configFileLocation, e);
            return null;
        }
    }
}

