/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.deployment.Artifact;
import org.wso2.carbon.kernel.deployment.ArtifactType;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.deployment.exception.CarbonDeploymentException;
import org.wso2.carbon.kernel.deployment.exception.DeployerRegistrationException;
import org.wso2.carbon.kernel.deployment.exception.DeploymentEngineException;
import org.wso2.carbon.kernel.internal.deployment.OSGiServiceHolder;
import org.wso2.carbon.kernel.internal.deployment.RepositoryScanner;
import org.wso2.carbon.kernel.internal.deployment.SchedulerTask;

public class DeploymentEngine {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEngine.class);
    private RepositoryScanner repositoryScanner;
    private File repositoryDirectory = null;
    private Map<ArtifactType, Deployer> deployerMap = new ConcurrentHashMap<ArtifactType, Deployer>();
    private Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> deployedArtifacts = new ConcurrentHashMap<ArtifactType, ConcurrentHashMap<Object, Artifact>>();

    public DeploymentEngine(String repositoryDir) throws DeploymentEngineException {
        logger.debug("Initializing carbon deployment engine for repository : " + repositoryDir);
        this.init(repositoryDir);
    }

    private void init(String repositoryDir) throws DeploymentEngineException {
        this.repositoryDirectory = new File(repositoryDir);
        if (!this.repositoryDirectory.exists()) {
            throw new DeploymentEngineException("Cannot find repository : " + this.repositoryDirectory);
        }
        this.repositoryScanner = new RepositoryScanner(this);
    }

    public void start() {
        this.repositoryScanner.scan();
        this.startScheduler();
    }

    private void startScheduler() {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(5);
        SchedulerTask schedulerTask = new SchedulerTask(this.repositoryScanner);
        CarbonRuntime carbonRuntime = OSGiServiceHolder.getInstance().getCarbonRuntime();
        int interval = 15;
        if (carbonRuntime != null) {
            interval = carbonRuntime.getConfiguration().getDeploymentConfig().getUpdateInterval();
            logger.debug("Using the specified scheduler update interval of {}", (Object)interval);
        } else {
            logger.debug("Using the default deployment scheduler update interval of 15 seconds");
        }
        executorService.scheduleWithFixedDelay(schedulerTask, 0L, interval, TimeUnit.SECONDS);
    }

    public void registerDeployer(Deployer deployer) throws DeployerRegistrationException {
        if (deployer == null) {
            throw new DeployerRegistrationException("Failed to add Deployer : Deployer Class Name is null");
        }
        deployer.init();
        if (deployer.getLocation() == null) {
            throw new DeployerRegistrationException("Failed to add Deployer " + deployer.getClass().getName() + ": missing 'directory' attribute " + "in deployer instance");
        }
        ArtifactType type = deployer.getArtifactType();
        if (type == null) {
            throw new DeployerRegistrationException("Artifact Type for Deployer : " + deployer + " is null");
        }
        Deployer existingDeployer = this.deployerMap.get(type);
        if (existingDeployer == null) {
            this.deployerMap.put(type, deployer);
        }
    }

    public void unregisterDeployer(Deployer deployer) throws DeploymentEngineException {
        ArtifactType type = deployer.getArtifactType();
        if (type == null) {
            throw new DeploymentEngineException("Artifact Type for Deployer : " + deployer + " is null");
        }
        Deployer existingDeployer = this.deployerMap.get(type);
        if (existingDeployer != null) {
            this.deployerMap.remove(type);
        }
    }

    public Deployer getDeployer(ArtifactType type) {
        Deployer existingDeployer = this.deployerMap.get(type);
        return existingDeployer != null ? existingDeployer : null;
    }

    public Map<ArtifactType, Deployer> getDeployers() {
        return this.deployerMap;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public Artifact getDeployedArtifact(ArtifactType type, Object artifactKey) {
        Artifact artifact = null;
        if (this.deployedArtifacts.get(type) != null) {
            artifact = this.deployedArtifacts.get(type).get(artifactKey);
        }
        return artifact;
    }

    public Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> getDeployedArtifacts() {
        return this.deployedArtifacts;
    }

    public void deployArtifacts(List<Artifact> artifactsToDeploy) {
        Iterator<Artifact> iterator = artifactsToDeploy.iterator();
        while (iterator.hasNext()) {
            Artifact artifact;
            Artifact artifactToDeploy = artifact = iterator.next();
            try {
                Deployer deployer = this.getDeployer(artifactToDeploy.getType());
                if (deployer != null) {
                    Object artifactKey = deployer.deploy(artifactToDeploy);
                    artifactToDeploy.setKey(artifactKey);
                    this.addToDeployedArtifacts(artifactToDeploy);
                    continue;
                }
                throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToDeploy.getType());
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while deploying artifacts", e);
            }
        }
    }

    public void updateArtifacts(List<Artifact> artifactsToUpdate) {
        Iterator<Artifact> iterator = artifactsToUpdate.iterator();
        while (iterator.hasNext()) {
            Artifact artifact;
            Artifact artifactToUpdate = artifact = iterator.next();
            try {
                Deployer deployer = this.getDeployer(artifactToUpdate.getType());
                if (deployer != null) {
                    Object artifactKey = deployer.update(artifactToUpdate);
                    artifactToUpdate.setKey(artifactKey);
                    this.addToDeployedArtifacts(artifactToUpdate);
                    continue;
                }
                throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToUpdate.getType());
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while updating artifacts", e);
            }
        }
    }

    private void addToDeployedArtifacts(Artifact artifact) {
        ConcurrentHashMap<Object, Artifact> artifactMap = this.deployedArtifacts.get(artifact.getType());
        if (artifactMap == null) {
            artifactMap = new ConcurrentHashMap();
        }
        artifactMap.put(artifact.getKey(), artifact);
        this.deployedArtifacts.put(artifact.getType(), artifactMap);
    }

    public void undeployArtifacts(List<Artifact> artifactsToUndeploy) {
        Iterator<Artifact> iterator = artifactsToUndeploy.iterator();
        while (iterator.hasNext()) {
            Artifact artifact;
            Artifact artifactToUnDeploy = artifact = iterator.next();
            try {
                Deployer deployer = this.getDeployer(artifactToUnDeploy.getType());
                if (deployer != null) {
                    deployer.undeploy(artifactToUnDeploy.getKey());
                    this.removeFromDeployedArtifacts(artifactToUnDeploy);
                    continue;
                }
                throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToUnDeploy.getType());
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while undeploying artifacts", e);
            }
        }
    }

    private void removeFromDeployedArtifacts(Artifact artifact) {
        Map artifactMap = this.deployedArtifacts.get(artifact.getType());
        if (artifactMap != null && artifactMap.containsKey(artifact.getKey())) {
            artifactMap.remove(artifact.getKey());
            if (artifactMap.isEmpty()) {
                this.deployedArtifacts.remove(artifact.getType());
            }
        }
    }
}

