/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.deployment.DeploymentService;
import org.wso2.carbon.kernel.deployment.exception.DeployerRegistrationException;
import org.wso2.carbon.kernel.deployment.exception.DeploymentEngineException;
import org.wso2.carbon.kernel.internal.deployment.CarbonDeploymentService;
import org.wso2.carbon.kernel.internal.deployment.DeploymentEngine;
import org.wso2.carbon.kernel.internal.deployment.OSGiServiceHolder;

@Component(name="org.wso2.carbon.kernel.internal.deployment.DeploymentEngineComponent", immediate=true)
public class DeploymentEngineComponent {
    private static Logger logger = LoggerFactory.getLogger(DeploymentEngineComponent.class);
    private CarbonRuntime carbonRuntime;
    private DeploymentEngine deploymentEngine;
    private ServiceRegistration serviceRegistration;
    private List<Deployer> deployerList = new ArrayList<Deployer>();

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        try {
            String carbonRepositoryLocation = this.carbonRuntime.getConfiguration().getDeploymentConfig().getRepositoryLocation();
            this.deploymentEngine = new DeploymentEngine(carbonRepositoryLocation);
            logger.debug("Starting Carbon Deployment Engine {}", (Object)this.deploymentEngine);
            this.deploymentEngine.start();
            OSGiServiceHolder.getInstance().setCarbonDeploymentEngine(this.deploymentEngine);
            CarbonDeploymentService deploymentService = new CarbonDeploymentService(this.deploymentEngine);
            this.serviceRegistration = bundleContext.registerService(DeploymentService.class.getName(), (Object)deploymentService, null);
            logger.debug("Started Carbon Deployment Engine");
            for (Deployer deployer : this.deployerList) {
                try {
                    this.deploymentEngine.registerDeployer(deployer);
                }
                catch (Exception e) {
                    logger.error("Error while adding deployer to the deployment engine", e);
                }
            }
        }
        catch (DeploymentEngineException e) {
            String msg = "Could not initialize carbon deployment engine";
            logger.error(msg, e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Deactivate
    public void stop() throws Exception {
        this.serviceRegistration.unregister();
    }

    @Reference(name="carbon.deployer.service", service=Deployer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeployer")
    protected void registerDeployer(Deployer deployer) {
        if (this.deploymentEngine != null) {
            try {
                this.deploymentEngine.registerDeployer(deployer);
            }
            catch (DeployerRegistrationException e) {
                logger.error("Error while adding deployer to the deployment engine", e);
            }
        } else {
            this.deployerList.add(deployer);
        }
    }

    protected void unregisterDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.unregisterDeployer(deployer);
        }
        catch (DeploymentEngineException e) {
            logger.error("Error while removing deployer from deployment engine", e);
        }
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonRuntime")
    public void setCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = carbonRuntime;
        OSGiServiceHolder.getInstance().setCarbonRuntime(carbonRuntime);
    }

    public void unsetCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = null;
        OSGiServiceHolder.getInstance().setCarbonRuntime(null);
    }
}

