/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.deployment.Artifact;
import org.wso2.carbon.kernel.deployment.ArtifactType;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.internal.deployment.DeploymentEngine;
import org.wso2.carbon.kernel.internal.deployment.Utils;

public class RepositoryScanner {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryScanner.class);
    private final DeploymentEngine carbonDeploymentEngine;
    private ArrayList<Artifact> artifactsToDeploy = new ArrayList();
    private ArrayList<Artifact> artifactsToUndeploy = new ArrayList();
    private ArrayList<Artifact> artifactsToUpdate = new ArrayList();
    private List<String> artifactFilePathList = new ArrayList<String>();

    public RepositoryScanner(DeploymentEngine carbonDeploymentEngine) {
        this.carbonDeploymentEngine = carbonDeploymentEngine;
    }

    public void scan() {
        logger.debug("Starting scanning of deployer directories");
        this.mark();
        this.sweep();
    }

    private void mark() {
        File carbonRepo = this.carbonDeploymentEngine.getRepositoryDirectory();
        for (Deployer deployer : this.carbonDeploymentEngine.getDeployers().values()) {
            File deploymentLocation = Utils.resolveFileURL(deployer.getLocation().getPath(), carbonRepo.getPath());
            this.findArtifactsToDeploy(deploymentLocation, deployer.getArtifactType());
        }
        this.checkUndeployedArtifacts();
    }

    private void sweep() {
        if (this.artifactsToUpdate.size() > 0) {
            try {
                this.carbonDeploymentEngine.updateArtifacts(this.artifactsToUpdate);
            }
            finally {
                this.artifactsToUpdate.clear();
            }
        }
        if (this.artifactsToUndeploy.size() > 0) {
            try {
                this.carbonDeploymentEngine.undeployArtifacts(this.artifactsToUndeploy);
            }
            finally {
                this.artifactsToUndeploy.clear();
            }
        }
        if (this.artifactsToDeploy.size() > 0) {
            try {
                this.carbonDeploymentEngine.deployArtifacts(this.artifactsToDeploy);
            }
            finally {
                this.artifactsToDeploy.clear();
            }
        }
    }

    private void findArtifactsToDeploy(File directoryToSearch, ArtifactType type) {
        File[] files = directoryToSearch.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                Artifact artifact = new Artifact(file);
                artifact.setType(type);
                this.addArtifactToDeploy(artifact);
            }
        }
    }

    private void addArtifactToDeploy(Artifact artifact) {
        Artifact deployedArtifact = this.findDeployedArtifact(artifact.getType(), artifact.getPath());
        if (deployedArtifact != null) {
            if (Utils.isArtifactModified(deployedArtifact)) {
                this.artifactsToUpdate.add(deployedArtifact);
            }
        } else {
            this.artifactsToDeploy.add(artifact);
            Utils.setArtifactLastModifiedTime(artifact);
        }
        this.artifactFilePathList.add(artifact.getPath());
    }

    private Artifact findDeployedArtifact(ArtifactType type, String path) {
        Artifact artifact = null;
        Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> deployedArtifacts = this.carbonDeploymentEngine.getDeployedArtifacts();
        if (deployedArtifacts.get(type) != null) {
            for (Artifact anArtifact : deployedArtifacts.get(type).values()) {
                if (!path.equals(anArtifact.getPath())) continue;
                artifact = anArtifact;
            }
        }
        return artifact;
    }

    private void checkUndeployedArtifacts() {
        Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> deployedArtifacts = this.carbonDeploymentEngine.getDeployedArtifacts();
        for (Map map : deployedArtifacts.values()) {
            for (Artifact artifact : map.values()) {
                String filePath = artifact.getPath();
                boolean found = false;
                for (String anArtifactFilePath : this.artifactFilePathList) {
                    String artifactFilePath = anArtifactFilePath;
                    if (!filePath.equals(artifactFilePath)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.artifactsToUndeploy.add(artifact);
            }
        }
        this.artifactFilePathList.clear();
    }
}

