/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiCounter<K> {
    private Map<K, AtomicInteger> counterMap = new ConcurrentHashMap<K, AtomicInteger>();

    public synchronized int incrementAndGet(K key) {
        if (!this.counterMap.containsKey(key)) {
            this.counterMap.put(key, new AtomicInteger(1));
            return 1;
        }
        return this.counterMap.get(key).incrementAndGet();
    }

    public synchronized int decrementAndGet(K key) {
        if (this.counterMap.containsKey(key)) {
            int tally = this.counterMap.get(key).decrementAndGet();
            if (tally == 0) {
                this.counterMap.remove(key);
                return tally;
            }
            return tally;
        }
        this.counterMap.put(key, new AtomicInteger(-1));
        return -1;
    }

    public int get(K key) {
        if (this.counterMap.get(key) == null) {
            return 0;
        }
        return this.counterMap.get(key).get();
    }

    public List<K> getAllKeys() {
        return new ArrayList<K>(this.counterMap.keySet());
    }
}

