/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.startupresolver.MultiCounter;
import org.wso2.carbon.kernel.startupresolver.CapabilityProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

@Component(name="org.wso2.carbon.kernel.internal.startupresolver.RequireCapabilityCoordinator", immediate=true)
public class RequireCapabilityCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(RequireCapabilityCoordinator.class);
    private static final String PROVIDE_CAPABILITY = "Provide-Capability";
    private static final String REQUIRED_SERVICE_INTERFACE = "required-service-interface";
    private AtomicInteger requiredCapabilityListenerCount = new AtomicInteger(0);
    private Map<String, RequiredCapabilityListener> listenerMap = new ConcurrentHashMap<String, RequiredCapabilityListener>();
    private MultiCounter<String> capabilityCounter = new MultiCounter();
    private Timer checkServiceAvailabilityTimer = new Timer();
    private Timer pendingServiceTimer = new Timer();

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        try {
            Arrays.asList(bundleContext.getBundles()).parallelStream().filter(new ProvideCapabilityHeaderFilter()).forEach(new ProvideCapabilityHeaderConsumer());
            if (this.requiredCapabilityListenerCount.get() == 0) {
                this.capabilityCounter = null;
                this.listenerMap = null;
                return;
            }
            this.checkServiceAvailabilityTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    RequireCapabilityCoordinator.this.listenerMap.keySet().stream().filter(key -> RequireCapabilityCoordinator.this.capabilityCounter.get(key) == 0 && RequireCapabilityCoordinator.this.listenerMap.get(key) != null).forEach(key -> {
                        String string = key.intern();
                        synchronized (string) {
                            logger.debug("Invoking {} from checkServiceAvailabilityTimer as its required capabilities are all available", key);
                            ((RequiredCapabilityListener)RequireCapabilityCoordinator.this.listenerMap.remove(key)).onAllRequiredCapabilitiesAvailable();
                        }
                    });
                }
            }, 200L, 200L);
        }
        catch (Throwable e) {
            logger.error("Error occurred while processing Provide-Capability manifest headers", e);
            throw e;
        }
    }

    @Deactivate
    public void stop(BundleContext bundleContext) throws Exception {
    }

    @Reference(name="require.capability.listener.service", service=RequiredCapabilityListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="deregisterRequireCapabilityListener")
    public void registerRequireCapabilityListener(final RequiredCapabilityListener listener, Map<String, String> propertyMap) {
        String requiredServiceKey = propertyMap.get(REQUIRED_SERVICE_INTERFACE);
        if (requiredServiceKey == null || requiredServiceKey.equals("")) {
            logger.warn("RequireCapabilityListener service ({}) does not contain the proper required-service-interface name", (Object)listener.getClass().getName());
            return;
        }
        requiredServiceKey = requiredServiceKey.trim();
        this.listenerMap.put(requiredServiceKey, listener);
        final BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            final String serviceClazz = requiredServiceKey;
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, requiredServiceKey, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object addingService(ServiceReference<Object> reference) {
                    String string = serviceClazz.intern();
                    synchronized (string) {
                        if (RequireCapabilityCoordinator.this.capabilityCounter.decrementAndGet(serviceClazz) == 0) {
                            logger.debug("Invoking {} from serviceTracker as its required capabilities are all available", (Object)serviceClazz);
                            listener.onAllRequiredCapabilitiesAvailable();
                        }
                    }
                    return bundleContext.getService(reference);
                }

                public void modifiedService(ServiceReference<Object> reference, Object service) {
                }

                public void removedService(ServiceReference<Object> reference, Object service) {
                }
            });
            serviceTracker.open();
        }
    }

    public void deregisterRequireCapabilityListener(RequiredCapabilityListener listener, Map<String, String> propertyMap) {
    }

    @Reference(name="capability.provider.service", service=CapabilityProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCapabilityProvider")
    public void registerCapabilityProvider(CapabilityProvider provider) {
        String dynamicCapabilityName = provider.getName();
        if (dynamicCapabilityName == null || dynamicCapabilityName.equals("")) {
            logger.warn("CapabilityProvider service ({}) does not contain the capability name", (Object)provider.getClass().getName());
        } else {
            logger.debug("Updating CapabilityCounter with Capability-Name : {} , Capability-Count : {}", (Object)provider.getName(), (Object)provider.getCount());
            String capabilityName = dynamicCapabilityName.trim();
            IntStream.range(0, provider.getCount()).forEach(count -> this.capabilityCounter.incrementAndGet(capabilityName));
        }
    }

    public void unregisterCapabilityProvider(CapabilityProvider provider) {
    }

    private class ProvideCapabilityHeaderConsumer<T extends Bundle>
    implements Consumer<T> {
        private ProvideCapabilityHeaderConsumer() {
        }

        @Override
        public void accept(final T bundle) {
            String headerValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return (String)bundle.getHeaders(RequireCapabilityCoordinator.PROVIDE_CAPABILITY).get(RequireCapabilityCoordinator.PROVIDE_CAPABILITY);
                }
            });
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)RequireCapabilityCoordinator.PROVIDE_CAPABILITY, (String)headerValue);
                Arrays.asList(elements).stream().filter(element -> "osgi.service".equals(element.getValue())).forEach(element -> {
                    if (RequiredCapabilityListener.class.getName().equals(element.getAttribute("objectClass"))) {
                        logger.debug("Adding Capability-Listener {} to watch list from bundle ({})", (Object)element.getAttribute("objectClass"), (Object)bundle.getSymbolicName());
                        RequireCapabilityCoordinator.this.requiredCapabilityListenerCount.incrementAndGet();
                    } else {
                        logger.debug("Updating Capability-Counter for {} from bundle ({})", (Object)element.getAttribute("objectClass"), (Object)bundle.getSymbolicName());
                        RequireCapabilityCoordinator.this.capabilityCounter.incrementAndGet(element.getAttribute("objectClass"));
                    }
                });
            }
            catch (BundleException e) {
                logger.error("Error occurred while parsing the {} header in bundle {}", new Object[]{RequireCapabilityCoordinator.PROVIDE_CAPABILITY, bundle.getSymbolicName(), e});
            }
        }
    }

    private static class ProvideCapabilityHeaderFilter<T extends Bundle>
    implements Predicate<T> {
        private ProvideCapabilityHeaderFilter() {
        }

        @Override
        public boolean test(final T bundle) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return bundle.getHeaders(RequireCapabilityCoordinator.PROVIDE_CAPABILITY).get(RequireCapabilityCoordinator.PROVIDE_CAPABILITY) != null;
                }
            });
        }
    }
}

