/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.transports;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.TransportManager;

public class TransportMgtCommandProvider
implements CommandProvider {
    private static final Logger logger = LoggerFactory.getLogger(TransportMgtCommandProvider.class);
    private TransportManager transportManager;

    public TransportMgtCommandProvider(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public String getHelp() {
        return "---Transport Management---\n\tstartTransport <transportName> - Start the specified transport with <transportName>.\n\tstopTransport <transportName> - Stop the specified transport with <transportName>\n\tstartTransports - Start all transports\n\tstopTransports - Stop all transports\n\tbeginMaintenance - Activate maintenance mode of all transports\n\tendMaintenance - Deactivate maintenance mode of all transports\n\tlistTransports - List all the available transports\n";
    }

    public void _startTransport(CommandInterpreter ci) {
        String transportName = ci.nextArgument();
        if (transportName == null || transportName.equals("")) {
            throw new IllegalArgumentException("Invalid transport.");
        }
        this.transportManager.startTransport(transportName);
    }

    public void _stopTransport(CommandInterpreter ci) {
        String transportName = ci.nextArgument();
        if (transportName == null || transportName.equals("")) {
            throw new IllegalArgumentException("Invalid transport.");
        }
        this.transportManager.stopTransport(transportName);
    }

    public void _startTransports(CommandInterpreter ci) {
        this.transportManager.startTransports();
    }

    public void _stopTransports(CommandInterpreter ci) {
        this.transportManager.stopTransports();
    }

    public void _beginMaintenance(CommandInterpreter ci) {
        this.transportManager.beginMaintenance();
    }

    public void _endMaintenance(CommandInterpreter ci) {
        this.transportManager.endMaintenance();
    }

    public void _listTransports(CommandInterpreter ci) {
        throw new UnsupportedOperationException("This method is not implemented, yet.");
    }
}

