/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.transports;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.kernel.transports.CarbonTransport;

public class TransportManager {
    private Map<String, CarbonTransport> transports = new HashMap<String, CarbonTransport>();

    public void registerTransport(CarbonTransport transport) {
        this.transports.put(transport.getId(), transport);
    }

    public void unregisterTransport(CarbonTransport transport) {
        this.transports.remove(transport.getId());
    }

    public void startTransport(String transportId) {
        CarbonTransport transport = this.transports.get(transportId);
        if (transport == null) {
            throw new IllegalArgumentException(transportId + " not found");
        }
        transport.startTransport();
    }

    public void stopTransport(String transportId) {
        CarbonTransport transport = this.transports.get(transportId);
        if (transport == null) {
            throw new IllegalArgumentException(transportId + " not found");
        }
        transport.stopTransport();
    }

    public void startTransports() {
        this.transports.entrySet().stream().forEach(entry -> ((CarbonTransport)entry.getValue()).startTransport());
    }

    public void stopTransports() {
        this.transports.entrySet().stream().forEach(entry -> ((CarbonTransport)entry.getValue()).stopTransport());
    }

    public void beginMaintenance() {
        this.transports.entrySet().stream().forEach(entry -> ((CarbonTransport)entry.getValue()).beginMaintenance());
    }

    public void endMaintenance() {
        this.transports.entrySet().stream().forEach(entry -> ((CarbonTransport)entry.getValue()).endMaintenance());
    }
}

