/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                boolean success = FileUtils.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void copyFile(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException e) {
            logger.warn("Unable to copy file " + e.getMessage(), e);
            throw new IOException("Unable to copy file ", e);
        }
    }

    public static void copyFileToDir(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        File file = new File(dstAbsPath + File.separator + src.getName());
        FileUtils.copyFile(src, file);
    }

    public static void archiveDir(String destArchive, String sourceDir) throws IOException {
        File zipDir = new File(sourceDir);
        if (!zipDir.isDirectory()) {
            throw new RuntimeException(sourceDir + " is not a directory");
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destArchive));){
            FileUtils.zipDir(zipDir, zos, sourceDir);
        }
    }

    protected static void zipDir(File zipDir, ZipOutputStream zos, String archiveSourceDir) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        if (dirList != null) {
            for (String aDirList : dirList) {
                File f = new File(zipDir, aDirList);
                zos.putNextEntry(new ZipEntry(FileUtils.getZipEntryPath(f, archiveSourceDir)));
                if (f.isDirectory()) {
                    FileUtils.zipDir(f, zos, archiveSourceDir);
                    continue;
                }
                try (FileInputStream fis = new FileInputStream(f);){
                    int bytesIn;
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                }
            }
        }
    }

    protected static String getZipEntryPath(File f, String archiveSourceDir) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }
}

