/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final String VAR_REGEXP = "\\$\\{[^}]*}";
    private static final Pattern varPattern = Pattern.compile("\\$\\{[^}]*}");

    private Utils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static Path getCarbonConfigHome() {
        String carbonRepoDirPath = System.getProperty("carbon.repository");
        if (carbonRepoDirPath == null) {
            carbonRepoDirPath = System.getenv("CARBON_REPOSITORY");
        }
        Path configDirPath = carbonRepoDirPath == null ? Paths.get(Utils.getCarbonHome().toString(), "repository", "conf") : Paths.get(carbonRepoDirPath, "conf");
        return configDirPath;
    }

    public static Path getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            System.setProperty("carbon.home", carbonHome);
        }
        return Paths.get(carbonHome, new String[0]);
    }

    public static String substituteVars(String value) {
        String newValue = value;
        Matcher matcher = varPattern.matcher(value);
        while (matcher.find()) {
            String sysPropKey = value.substring(matcher.start() + 2, matcher.end() - 1);
            String sysPropValue = System.getProperty(sysPropKey);
            if (sysPropValue == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " cannot be null");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            newValue = newValue.replaceFirst(VAR_REGEXP, sysPropValue);
        }
        return newValue;
    }
}

