/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Map;
import org.wso2.carbon.mss.internal.MicroservicesRegistry;
import org.wso2.carbon.mss.internal.router.HttpDispatcher;
import org.wso2.carbon.mss.internal.router.RequestRouter;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;

public class MSSNettyServerInitializer
implements CarbonNettyServerInitializer {
    private DefaultEventExecutorGroup eventExecutorGroup;
    private MicroservicesRegistry microservicesRegistry;

    public MSSNettyServerInitializer(MicroservicesRegistry microservicesRegistry) {
        this.microservicesRegistry = microservicesRegistry;
    }

    @Override
    public void setup(Map<String, String> map) {
        this.eventExecutorGroup = new DefaultEventExecutorGroup(200);
    }

    @Override
    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast((EventExecutorGroup)this.eventExecutorGroup, "router", (ChannelHandler)new RequestRouter(this.microservicesRegistry.getHttpResourceHandler(), 0));
        pipeline.addLast((EventExecutorGroup)this.eventExecutorGroup, "dispatcher", (ChannelHandler)new HttpDispatcher());
    }
}

