/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal;

import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.mss.HttpHandler;
import org.wso2.carbon.mss.internal.MSSNettyServerInitializer;
import org.wso2.carbon.mss.internal.MicroservicesRegistry;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;

@Component(name="org.wso2.carbon.mss.internal.MicroServicesServerSC", immediate=true)
public class MicroServicesServerSC {
    public static final String CHANNEL_ID_KEY = "channel.id";
    private static final Logger log = LoggerFactory.getLogger(MicroServicesServerSC.class);
    private static final Logger LOG = LoggerFactory.getLogger(MicroServicesServerSC.class);
    private final MicroservicesRegistry microservicesRegistry = MicroservicesRegistry.getInstance();
    private BundleContext bundleContext;
    private int jaxRsServiceCount;

    @Activate
    protected void start(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        try {
            this.countJaxrsServices();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (MicroServicesServerSC.this.microservicesRegistry.getServiceCount() == MicroServicesServerSC.this.jaxRsServiceCount) break;
                        try {
                            TimeUnit.MILLISECONDS.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    LOG.info("Starting micro services server...");
                    Hashtable<String, String> httpInitParams = new Hashtable<String, String>();
                    httpInitParams.put(MicroServicesServerSC.CHANNEL_ID_KEY, "netty-jaxrs-http");
                    bundleContext.registerService(CarbonNettyServerInitializer.class, (Object)new MSSNettyServerInitializer(MicroservicesRegistry.getInstance()), httpInitParams);
                    Hashtable<String, String> httpsInitParams = new Hashtable<String, String>();
                    httpsInitParams.put(MicroServicesServerSC.CHANNEL_ID_KEY, "netty-jaxrs-https");
                    bundleContext.registerService(CarbonNettyServerInitializer.class, (Object)new MSSNettyServerInitializer(MicroservicesRegistry.getInstance()), httpsInitParams);
                    LOG.info("Micro services server started");
                }
            }).start();
        }
        catch (Throwable e) {
            LOG.error("Could not start MicroServicesServerSC", e);
        }
    }

    private void countJaxrsServices() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            String jaxRsServices = (String)bundle.getHeaders().get("JAXRS-Services");
            if (jaxRsServices == null) continue;
            this.jaxRsServiceCount += Integer.parseInt(jaxRsServices);
        }
    }

    @Reference(name="netty-http.handler", service=HttpHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeHttpService")
    protected void addHttpService(HttpHandler httpService) {
        this.microservicesRegistry.addHttpService(httpService);
    }

    protected void removeHttpService(HttpHandler httpService) {
        this.microservicesRegistry.removeHttpService(httpService);
    }
}

