/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.mss.internal.router.ExceptionHandler;
import org.wso2.carbon.mss.internal.router.HttpResourceHandler;
import org.wso2.carbon.mss.internal.router.Interceptor;
import org.wso2.carbon.mss.internal.router.URLRewriter;

public class MicroservicesRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MicroservicesRegistry.class);
    private static final MicroservicesRegistry instance = new MicroservicesRegistry();
    private final Set<Object> httpServices = new HashSet<Object>();
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private URLRewriter urlRewriter = null;
    private volatile HttpResourceHandler httpResourceHandler = new HttpResourceHandler(Collections.emptyList(), this.interceptors, this.urlRewriter, new ExceptionHandler());

    private MicroservicesRegistry() {
    }

    public static MicroservicesRegistry getInstance() {
        return instance;
    }

    public static MicroservicesRegistry newInstance() {
        return new MicroservicesRegistry();
    }

    public void addHttpService(Object httpHandler) {
        this.httpServices.add(httpHandler);
        this.updateHttpResourceHandler();
        LOG.info("Added HTTP Service: " + httpHandler);
    }

    public void removeHttpService(Object httpService) {
        this.httpServices.remove(httpService);
        this.updateHttpResourceHandler();
    }

    public HttpResourceHandler getHttpResourceHandler() {
        return this.httpResourceHandler;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        this.updateHttpResourceHandler();
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.updateHttpResourceHandler();
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
        this.updateHttpResourceHandler();
    }

    public int getServiceCount() {
        return this.httpServices.size();
    }

    private void updateHttpResourceHandler() {
        this.httpResourceHandler = new HttpResourceHandler(Collections.unmodifiableSet(this.httpServices), this.interceptors, this.urlRewriter, new ExceptionHandler());
    }
}

