/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.deployer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.deployment.Artifact;
import org.wso2.carbon.kernel.deployment.ArtifactType;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.deployment.exception.CarbonDeploymentException;
import org.wso2.carbon.mss.internal.MicroservicesRegistry;
import org.wso2.carbon.mss.internal.deployer.MSSJarProcessor;
import org.wso2.carbon.mss.internal.deployer.MSSJarProcessorException;

@Component(name="org.wso2.carbon.mss.internal.deployer.MSSDeployer", service={Deployer.class}, immediate=true)
public class MSSDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(MSSDeployer.class);
    private static final String DEPLOYMENT_PATH = "file:mss";
    private URL deploymentLocation;
    private ArtifactType artifactType;
    private HashMap<Object, List<Object>> deployedArtifacts = new HashMap();

    @Override
    public void init() {
        log.info("MSSDeployer initializing");
        this.artifactType = new ArtifactType<String>("MSS");
        try {
            this.deploymentLocation = new URL(DEPLOYMENT_PATH);
        }
        catch (MalformedURLException e) {
            log.error("MSS deployer location error");
        }
    }

    @Override
    public Object deploy(Artifact artifact) throws CarbonDeploymentException {
        File artifactFile = artifact.getFile();
        String artifactPath = artifactFile.getAbsolutePath();
        log.info("Deploying artifact: {}", (Object)artifactPath);
        List<Object> resourcesList = null;
        try {
            resourcesList = new MSSJarProcessor().setArtifact(artifactFile).process().getResourceInstances();
        }
        catch (MSSJarProcessorException e) {
            throw new CarbonDeploymentException("Error while processing the artifact: " + artifactPath, e);
        }
        if (resourcesList.size() == 0) {
            throw new CarbonDeploymentException("No classes to initialize in artifact: " + artifactPath);
        }
        artifact.setKey(artifactPath);
        this.deployedArtifacts.put(artifactPath, resourcesList);
        for (Object resource : resourcesList) {
            MicroservicesRegistry.getInstance().addHttpService(resource);
        }
        return artifactPath;
    }

    @Override
    public void undeploy(Object key) throws CarbonDeploymentException {
        log.info("Undeploying artifact: {}", key);
        List<Object> resourcesList = this.deployedArtifacts.get(key);
        for (Object resource : resourcesList) {
            MicroservicesRegistry.getInstance().removeHttpService(resource);
        }
    }

    @Override
    public Object update(Artifact artifact) throws CarbonDeploymentException {
        File artifactFile = artifact.getFile();
        String artifactPath = artifactFile.getAbsolutePath();
        log.info("Updating artifact: {}", (Object)artifactPath);
        this.undeploy(artifact.getKey());
        this.deploy(artifact);
        return artifactPath;
    }

    @Override
    public URL getLocation() {
        return this.deploymentLocation;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }
}

