/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.deployer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.mss.internal.deployer.MSSJarProcessorException;

public class MSSJarProcessor {
    private static final Logger log = LoggerFactory.getLogger(MSSJarProcessor.class);
    private static final String MICROSERVICES_MANIFEST_KEY = "Microservices";
    private File file;
    private List<Object> resourceInstances = new ArrayList<Object>();

    public MSSJarProcessor setArtifact(File file) {
        this.file = file;
        return this;
    }

    public MSSJarProcessor process() throws MSSJarProcessorException {
        block2: {
            String jarPath = this.file.getAbsolutePath();
            final String[] mssClassNames = this.readMSSManifestEntry(jarPath);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MSSJarProcessorException {
                        try {
                            URLClassLoader classLoader = new URLClassLoader(new URL[]{MSSJarProcessor.this.file.toURI().toURL()}, this.getClass().getClassLoader());
                            for (String className : mssClassNames) {
                                try {
                                    Class<?> classToLoad = classLoader.loadClass(className);
                                    MSSJarProcessor.this.resourceInstances.add(classToLoad.newInstance());
                                }
                                catch (ClassNotFoundException e) {
                                    throw new MSSJarProcessorException("Class: " + className + " not found", e);
                                }
                                catch (InstantiationException e) {
                                    throw new MSSJarProcessorException("Failed to initialize class: " + className, e);
                                }
                                catch (IllegalAccessException e) {
                                    throw new MSSJarProcessorException("Failed to access class: " + className, e);
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new MSSJarProcessorException("Path to jar is invalid", e);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (!(e1 instanceof MSSJarProcessorException)) break block2;
                throw (MSSJarProcessorException)e1;
            }
        }
        return this;
    }

    private String[] readMSSManifestEntry(String jarPath) throws MSSJarProcessorException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new MSSJarProcessorException("Error retrieving manifest: " + jarPath);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String mssEntry = mainAttributes.getValue(MICROSERVICES_MANIFEST_KEY);
            if (mssEntry == null) {
                throw new MSSJarProcessorException("Manifest entry 'microservices' not found: " + jarPath);
            }
            String[] stringArray = mssEntry.split("\\s*,\\s*");
            return stringArray;
        }
        catch (IOException e) {
            throw new MSSJarProcessorException("Error retrieving manifest: " + jarPath, e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    log.warn("Cannot close jar file: " + jarPath, e);
                }
            }
        }
    }

    public List<Object> getResourceInstances() {
        return this.resourceInstances;
    }
}

