/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.wso2.carbon.mss.HttpResponder;

public abstract class AbstractHttpResponder
implements HttpResponder {
    private static final Gson GSON = new Gson();

    @Override
    public void sendJson(HttpResponseStatus status, Object object) {
        this.sendJson(status, object, object.getClass());
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type) {
        this.sendJson(status, object, type, GSON);
    }

    @Override
    public void sendJson(HttpResponseStatus status, Object object, Type type, Gson gson) {
        try {
            ByteBuf channelBuffer = Unpooled.buffer();
            try (JsonWriter jsonWriter = new JsonWriter(new OutputStreamWriter((OutputStream)new ByteBufOutputStream(channelBuffer), Charsets.UTF_8));){
                gson.toJson(object, type, jsonWriter);
            }
            this.sendContent(status, channelBuffer, "application/json", ImmutableMultimap.of());
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void sendString(HttpResponseStatus status, String data) {
        this.sendString(status, data, null);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data, @Nullable Multimap<String, String> headers) {
        if (data == null) {
            this.sendStatus(status, headers);
            return;
        }
        try {
            ByteBuf channelBuffer = Unpooled.wrappedBuffer(Charsets.UTF_8.encode(data));
            this.sendContent(status, channelBuffer, "text/plain; charset=utf-8", headers);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void sendStatus(HttpResponseStatus status) {
        this.sendContent(status, null, null, ImmutableMultimap.of());
    }

    @Override
    public void sendStatus(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        this.sendContent(status, null, null, headers);
    }

    @Override
    public void sendByteArray(HttpResponseStatus status, byte[] bytes, @Nullable Multimap<String, String> headers) {
        ByteBuf channelBuffer = Unpooled.wrappedBuffer(bytes);
        this.sendContent(status, channelBuffer, "application/octet-stream", headers);
    }

    @Override
    public void sendBytes(HttpResponseStatus status, ByteBuffer buffer, @Nullable Multimap<String, String> headers) {
        this.sendContent(status, Unpooled.wrappedBuffer(buffer), "application/octet-stream", headers);
    }
}

