/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.mss.ChunkResponder;

final class ChannelChunkResponder
implements ChunkResponder {
    private static final Logger log = LoggerFactory.getLogger(ChannelChunkResponder.class);
    private final Channel channel;
    private final boolean keepAlive;
    private final AtomicBoolean closed;

    ChannelChunkResponder(Channel channel, boolean keepAlive) {
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void sendChunk(ByteBuffer chunk) throws IOException {
        this.sendChunk(Unpooled.wrappedBuffer(chunk));
    }

    @Override
    public void sendChunk(ByteBuf chunk) throws IOException {
        if (this.closed.get()) {
            throw new IOException("ChunkResponder already closed.");
        }
        if (!this.channel.isWritable()) {
            throw new IOException("Connection already closed.");
        }
        this.channel.write(new DefaultHttpContent(chunk));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (!this.keepAlive && log.isDebugEnabled()) {
            log.debug("Keep-alive enabled");
        }
    }
}

