/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.AttributeKey;
import org.wso2.carbon.mss.internal.router.HandlerException;
import org.wso2.carbon.mss.internal.router.HttpMethodInfoBuilder;
import org.wso2.carbon.mss.internal.router.RequestRouter;

public class HttpDispatcher
extends SimpleChannelInboundHandler<HttpObject> {
    private HttpMethodInfoBuilder httpMethodInfoBuilder;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws HandlerException {
        Object httpMethodInfoBuilderObj = ctx.pipeline().context(RequestRouter.class).attr(AttributeKey.valueOf("METHOD_INFO_BUILDER")).get();
        if (httpMethodInfoBuilderObj instanceof HttpMethodInfoBuilder) {
            this.httpMethodInfoBuilder = (HttpMethodInfoBuilder)httpMethodInfoBuilderObj;
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest fullHttpRequest = (FullHttpRequest)msg;
                this.httpMethodInfoBuilder.httpRequest(fullHttpRequest).build().invoke();
            } else if (msg instanceof HttpContent) {
                this.httpMethodInfoBuilder.build().chunk((HttpContent)msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws HandlerException {
        if (this.httpMethodInfoBuilder != null) {
            this.httpMethodInfoBuilder.getHttpResourceModel().getExceptionHandler().handle(cause, this.httpMethodInfoBuilder.getRequest(), this.httpMethodInfoBuilder.getResponder());
        }
    }
}

