/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.wso2.carbon.mss.HttpResponder;
import org.wso2.carbon.mss.HttpStreamHandler;
import org.wso2.carbon.mss.HttpStreamer;
import org.wso2.carbon.mss.internal.router.ExceptionHandler;
import org.wso2.carbon.mss.internal.router.HandlerException;
import org.wso2.carbon.mss.internal.router.HttpMethodResponseHandler;
import org.wso2.carbon.mss.internal.router.beanconversion.BeanConversionException;

class HttpMethodInfo {
    private final Method method;
    private final Object handler;
    private final HttpRequest request;
    private final HttpResponder responder;
    private final Object[] args;
    private final ExceptionHandler exceptionHandler;
    private final String mediaType;
    private HttpStreamHandler httpStreamHandler;

    HttpMethodInfo(Method method, Object handler, HttpRequest request, HttpResponder responder, Object[] args, ExceptionHandler exceptionHandler, String mediaType) {
        this.method = method;
        this.handler = handler;
        this.request = request;
        this.responder = responder;
        this.exceptionHandler = exceptionHandler;
        this.mediaType = mediaType;
        this.args = args;
    }

    HttpMethodInfo(Method method, Object handler, HttpRequest request, HttpResponder responder, Object[] args, ExceptionHandler exceptionHandler, String mediaType, HttpStreamer httpStreamer) throws HandlerException {
        this(method, handler, request, responder, args, exceptionHandler, mediaType);
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Resource method should be void if it accepts chunked requests");
        }
        try {
            method.invoke(handler, args);
        }
        catch (InvocationTargetException e) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Resource method invocation failed", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Resource method invocation access failed", e);
        }
        this.httpStreamHandler = httpStreamer.getHttpStreamHandler();
        if (this.httpStreamHandler == null) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Streaming unsupported");
        }
    }

    void invoke() {
        try {
            Object returnVal = this.method.invoke(this.handler, this.args);
            new HttpMethodResponseHandler().setResponder(this.responder).setEntity(returnVal).setMediaType(this.mediaType).send();
        }
        catch (InvocationTargetException e) {
            this.exceptionHandler.handle(e.getTargetException(), this.request, this.responder);
        }
        catch (IllegalAccessException | BeanConversionException e) {
            this.exceptionHandler.handle(e, this.request, this.responder);
        }
    }

    void chunk(HttpContent chunk) {
        if (this.httpStreamHandler == null) {
            return;
        }
        try {
            if (chunk instanceof LastHttpContent) {
                this.bodyConsumerFinish(chunk.content());
            } else {
                this.bodyConsumerChunk(chunk.content());
            }
        }
        catch (HandlerException e) {
            this.exceptionHandler.handle(e, this.request, this.responder);
        }
    }

    void error(Throwable e) {
        try {
            if (this.httpStreamHandler != null) {
                this.bodyConsumerError(e);
            }
            this.exceptionHandler.handle(e, this.request, this.responder);
        }
        catch (HandlerException ex) {
            this.exceptionHandler.handle(ex, this.request, this.responder);
        }
    }

    private void bodyConsumerChunk(ByteBuf buffer) throws HandlerException {
        try {
            this.httpStreamHandler.chunk(buffer, this.responder);
        }
        catch (Throwable t) {
            this.bodyConsumerError(t);
        }
    }

    private void bodyConsumerFinish(ByteBuf buffer) throws HandlerException {
        try {
            HttpStreamHandler consumer = this.httpStreamHandler;
            this.httpStreamHandler = null;
            consumer.finished(buffer, this.responder);
        }
        catch (Throwable t) {
            this.bodyConsumerError(t);
        }
    }

    private void bodyConsumerError(Throwable cause) throws HandlerException {
        HttpStreamHandler consumer = this.httpStreamHandler;
        this.httpStreamHandler = null;
        consumer.error(cause);
        throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "", cause);
    }
}

