/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import com.google.common.base.Charsets;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.wso2.carbon.mss.HttpResponder;
import org.wso2.carbon.mss.internal.router.beanconversion.BeanConversionException;
import org.wso2.carbon.mss.internal.router.beanconversion.BeanConverter;

public class HttpMethodResponseHandler {
    private HttpResponder responder;
    private HttpResponseStatus status = null;
    private String mediaType = null;
    private Object entity;
    private Multimap<String, String> headers = LinkedListMultimap.create();

    public HttpMethodResponseHandler setResponder(HttpResponder responder) {
        this.responder = responder;
        return this;
    }

    public HttpMethodResponseHandler setStatus(int status) {
        this.status = HttpResponseStatus.valueOf(status);
        return this;
    }

    public HttpMethodResponseHandler setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public HttpMethodResponseHandler setEntity(Object entity) {
        if (entity instanceof Response) {
            Response response = (Response)entity;
            this.entity = response.getEntity();
            MultivaluedMap<String, String> multivaluedMap = response.getStringHeaders();
            if (multivaluedMap != null) {
                multivaluedMap.forEach(this.headers::putAll);
            }
            this.setStatus(response.getStatus());
            if (response.getMediaType() != null) {
                this.setMediaType(response.getMediaType().toString());
            }
        } else {
            this.entity = entity;
        }
        return this;
    }

    public void send() throws BeanConversionException {
        HttpResponseStatus status = this.status != null ? this.status : (this.entity != null ? HttpResponseStatus.OK : HttpResponseStatus.NO_CONTENT);
        if (this.entity != null) {
            Object entityToSend;
            if (this.mediaType != null) {
                entityToSend = BeanConverter.instance(this.mediaType).toMedia(this.entity);
            } else {
                this.mediaType = "";
                entityToSend = this.entity;
            }
            ByteBuf channelBuffer = Unpooled.wrappedBuffer(Charsets.UTF_8.encode(String.valueOf(entityToSend)));
            this.responder.sendContent(status, channelBuffer, this.mediaType, this.headers);
        } else {
            this.responder.sendStatus(status, this.headers);
        }
    }
}

