/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.wso2.carbon.mss.HttpResponder;
import org.wso2.carbon.mss.HttpStreamer;
import org.wso2.carbon.mss.internal.router.HandlerException;
import org.wso2.carbon.mss.internal.router.HttpMethodInfo;
import org.wso2.carbon.mss.internal.router.HttpResourceModel;
import org.wso2.carbon.mss.internal.router.beanconversion.BeanConverter;

public class HttpResourceModelProcessor {
    private final HttpResourceModel httpResourceModel;
    private HttpStreamer httpStreamer;

    public HttpResourceModelProcessor(HttpResourceModel httpResourceModel) {
        this.httpResourceModel = httpResourceModel;
    }

    public HttpMethodInfo buildHttpMethodInfo(HttpRequest request, HttpResponder responder, Map<String, String> groupValues, String contentType, List<String> acceptTypes) throws HandlerException {
        try {
            if (this.httpResourceModel.getHttpMethod().contains(request.getMethod())) {
                List<HttpResourceModel.ParameterInfo<?>> paramInfoList = this.httpResourceModel.getParamInfoList();
                List<String> producesMediaTypes = this.httpResourceModel.getProducesMediaTypes();
                Object[] args = new Object[paramInfoList.size()];
                String acceptType = "*/*";
                if (!producesMediaTypes.contains("*/*") && acceptTypes != null) {
                    acceptType = acceptTypes.contains("*/*") ? producesMediaTypes.get(0) : producesMediaTypes.stream().filter(acceptTypes::contains).findFirst().get();
                }
                int idx = 0;
                for (HttpResourceModel.ParameterInfo<Object> parameterInfo : paramInfoList) {
                    if (parameterInfo.getAnnotation() != null) {
                        Class<? extends Annotation> annotationType = parameterInfo.getAnnotation().annotationType();
                        if (PathParam.class.isAssignableFrom(annotationType)) {
                            args[idx] = this.getPathParamValue(parameterInfo, groupValues);
                        } else if (QueryParam.class.isAssignableFrom(annotationType)) {
                            args[idx] = this.getQueryParamValue(parameterInfo, request.getUri());
                        } else if (HeaderParam.class.isAssignableFrom(annotationType)) {
                            args[idx] = this.getHeaderParamValue(parameterInfo, request);
                        } else if (Context.class.isAssignableFrom(annotationType)) {
                            args[idx] = this.getContextParamValue(parameterInfo, request, responder);
                        }
                    } else if (request instanceof FullHttpRequest) {
                        String content = ((FullHttpRequest)request).content().toString(Charsets.UTF_8);
                        Type paramType = parameterInfo.getParameterType();
                        args[idx] = BeanConverter.instance(contentType != null ? contentType : "*/*").toObject(content, paramType);
                    }
                    ++idx;
                }
                if (this.httpStreamer == null) {
                    return new HttpMethodInfo(this.httpResourceModel.getMethod(), this.httpResourceModel.getHttpHandler(), request, responder, args, this.httpResourceModel.getExceptionHandler(), acceptType);
                }
                return new HttpMethodInfo(this.httpResourceModel.getMethod(), this.httpResourceModel.getHttpHandler(), request, responder, args, this.httpResourceModel.getExceptionHandler(), acceptType, this.httpStreamer);
            }
            throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Problem accessing: %s. Reason: Method Not Allowed", request.getUri()));
        }
        catch (Throwable e) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error in executing request: %s %s", request.getMethod(), request.getUri()), e);
        }
    }

    private Object getContextParamValue(HttpResourceModel.ParameterInfo<Object> paramInfo, HttpRequest request, HttpResponder responder) {
        Type paramType = paramInfo.getParameterType();
        Object value = null;
        if (((Class)paramType).isAssignableFrom(HttpRequest.class)) {
            value = request;
        } else if (((Class)paramType).isAssignableFrom(HttpResponder.class)) {
            value = responder;
        } else if (((Class)paramType).isAssignableFrom(HttpStreamer.class)) {
            if (this.httpStreamer == null) {
                this.httpStreamer = new HttpStreamer();
            }
            value = this.httpStreamer;
        }
        Preconditions.checkArgument(value != null, "Could not resolve parameter %s", paramType.getTypeName());
        return value;
    }

    private Object getPathParamValue(HttpResourceModel.ParameterInfo<String> info, Map<String, String> groupValues) {
        String defaultVal;
        PathParam pathParam = (PathParam)info.getAnnotation();
        String value = groupValues.get(pathParam.value());
        Preconditions.checkArgument(value != null, "Could not resolve value for parameter %s", pathParam.value());
        if (value == null && (defaultVal = info.getDefaultVal()) != null) {
            value = defaultVal;
        }
        return info.convert(value);
    }

    private Object getQueryParamValue(HttpResourceModel.ParameterInfo<List<String>> info, String uri) {
        String defaultVal;
        QueryParam queryParam = (QueryParam)info.getAnnotation();
        List<String> values = new QueryStringDecoder(uri).parameters().get(queryParam.value());
        if ((values == null || values.isEmpty()) && (defaultVal = info.getDefaultVal()) != null) {
            values = Arrays.asList(defaultVal);
        }
        return info.convert(values);
    }

    private Object getHeaderParamValue(HttpResourceModel.ParameterInfo<List<String>> info, HttpRequest request) {
        String defaultVal;
        HeaderParam headerParam = (HeaderParam)info.getAnnotation();
        String headerName = headerParam.value();
        List<String> headers = request.headers().getAll(headerName);
        if ((headers == null || headers.isEmpty()) && (defaultVal = info.getDefaultVal()) != null) {
            headers = Arrays.asList(defaultVal);
        }
        return info.convert(headers);
    }
}

