/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.internal.router;

import com.google.common.io.Closeables;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.carbon.mss.internal.router.SSLConfig;

public class SSLHandlerFactory {
    private static final String protocol = "TLS";
    private final SSLContext serverContext;
    private boolean needClientAuth;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = SSLHandlerFactory.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, sslConfig.getCertificatePassword() != null ? sslConfig.getCertificatePassword().toCharArray() : sslConfig.getKeyStorePassword().toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            TrustManager[] trustManagers = null;
            if (sslConfig.getTrustKeyStore() != null) {
                this.needClientAuth = true;
                KeyStore tks = SSLHandlerFactory.getKeyStore(sslConfig.getTrustKeyStore(), sslConfig.getTrustKeyStorePassword());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(tks);
                trustManagers = tmf.getTrustManagers();
            }
            this.serverContext = SSLContext.getInstance(protocol);
            this.serverContext.init(keyManagers, trustManagers, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Failed to initialize the server-side SSLContext", e);
        }
    }

    private static KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore ks = null;
        FileInputStream is = new FileInputStream(keyStore);
        try {
            ks = KeyStore.getInstance("JKS");
            ks.load(is, keyStorePassword.toCharArray());
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IOException(ex);
        }
        finally {
            Closeables.closeQuietly(is);
        }
        return ks;
    }

    public SslHandler create() {
        SSLEngine engine = this.serverContext.createSSLEngine();
        engine.setNeedClientAuth(this.needClientAuth);
        engine.setUseClientMode(false);
        return new SslHandler(engine);
    }
}

