/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mss.metrics;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.annotation.Counted;
import org.wso2.carbon.metrics.annotation.Metered;
import org.wso2.carbon.metrics.annotation.Timed;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.MetricServiceImpl;
import org.wso2.carbon.metrics.impl.MetricsLevelConfigException;
import org.wso2.carbon.metrics.impl.MetricsLevelConfiguration;
import org.wso2.carbon.metrics.impl.util.ConsoleReporterBuilder;
import org.wso2.carbon.metrics.impl.util.DASReporterBuilder;
import org.wso2.carbon.metrics.impl.util.JmxReporterBuilder;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.metrics.manager.Timer;
import org.wso2.carbon.metrics.manager.internal.ServiceReferenceHolder;
import org.wso2.carbon.mss.HttpResponder;
import org.wso2.carbon.mss.internal.router.HandlerInfo;
import org.wso2.carbon.mss.internal.router.Interceptor;
import org.wso2.carbon.mss.metrics.MetricReporter;
import org.wso2.carbon.mss.metrics.MetricsEnvConfiguration;

public class MetricsInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MetricsInterceptor.class);
    private Map<Method, Set<Interceptor>> map;
    private final MetricServiceImpl metricServiceImpl;
    private final MetricsEnvConfiguration metricsEnvConfiguration;

    public MetricsInterceptor(MetricReporter ... metricReporters) {
        MetricsLevelConfiguration metricsLevelConfiguration;
        block9: {
            this.map = new ConcurrentHashMap<Method, Set<Interceptor>>();
            if (logger.isDebugEnabled()) {
                logger.debug("Creating Metrics Interceptor");
            }
            this.metricsEnvConfiguration = new MetricsEnvConfiguration();
            metricsLevelConfiguration = new MetricsLevelConfiguration();
            try {
                metricsLevelConfiguration.loadFromSystemPropertyFile();
            }
            catch (MetricsLevelConfigException e) {
                if (!logger.isWarnEnabled()) break block9;
                logger.warn("Error loading metrics level configuration", e);
            }
        }
        MetricServiceImpl.Builder builder = new MetricServiceImpl.Builder().setEnabled(true).setRootLevel(Level.INFO);
        block7: for (MetricReporter metricReporter : metricReporters) {
            switch (metricReporter) {
                case CONSOLE: {
                    builder.addReporterBuilder(new ConsoleReporterBuilder().setEnabled(true).configure((MetricsConfiguration)this.metricsEnvConfiguration));
                    continue block7;
                }
                case DAS: {
                    builder.addReporterBuilder(new DASReporterBuilder().setEnabled(true).configure((MetricsConfiguration)this.metricsEnvConfiguration));
                    continue block7;
                }
                case JMX: {
                    builder.addReporterBuilder(new JmxReporterBuilder().setEnabled(true).configure((MetricsConfiguration)this.metricsEnvConfiguration));
                    continue block7;
                }
            }
        }
        this.metricServiceImpl = (MetricServiceImpl)builder.build(metricsLevelConfiguration);
        ServiceReferenceHolder.getInstance().setMetricService((MetricService)this.metricServiceImpl);
        MetricManager.registerMXBean();
    }

    @Override
    public boolean preCall(HttpRequest request, HttpResponder responder, HandlerInfo handlerInfo) {
        Method method = handlerInfo.getMethod();
        Set<Interceptor> interceptors = this.map.get(method);
        if (interceptors == null) {
            Interceptor interceptor;
            org.wso2.carbon.metrics.annotation.Level level;
            String name;
            Timed annotation;
            if (method.isAnnotationPresent(Timed.class)) {
                annotation = method.getAnnotation(Timed.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Timer timer = MetricManager.timer((Level)this.toLevel(level), (String)name);
                interceptor = new TimerInterceptor(timer);
                interceptors = new HashSet<Interceptor>();
                interceptors.add(interceptor);
            }
            if (method.isAnnotationPresent(Metered.class)) {
                annotation = method.getAnnotation(Metered.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Meter meter = MetricManager.meter((Level)this.toLevel(level), (String)name);
                interceptor = new MeterInterceptor(meter);
                if (interceptors == null) {
                    interceptors = new HashSet<Interceptor>();
                }
                interceptors.add(interceptor);
            }
            if (method.isAnnotationPresent(Counted.class)) {
                annotation = method.getAnnotation(Counted.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Counter counter = MetricManager.counter((Level)this.toLevel(level), (String)name);
                interceptor = new CounterInterceptor(counter, annotation.monotonic());
                if (interceptors == null) {
                    interceptors = new HashSet<Interceptor>();
                }
                interceptors.add(interceptor);
            }
            if (interceptors != null && !interceptors.isEmpty()) {
                this.map.put(method, interceptors);
            }
        }
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                interceptor.preCall(request, responder, handlerInfo);
            }
        }
        return true;
    }

    @Override
    public void postCall(HttpRequest request, HttpResponseStatus status, HandlerInfo handlerInfo) {
        Method method = handlerInfo.getMethod();
        Set<Interceptor> interceptors = this.map.get(method);
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                interceptor.postCall(request, status, handlerInfo);
            }
        }
    }

    private String buildName(String explicitName, boolean absolute, Method method) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricManager.name((String)method.getDeclaringClass().getName(), (String[])new String[]{method.getName(), explicitName});
        }
        return MetricManager.name((String)method.getDeclaringClass().getName(), (String[])new String[]{method.getName()});
    }

    private Level toLevel(org.wso2.carbon.metrics.annotation.Level level) {
        switch (level) {
            case OFF: {
                return Level.OFF;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case ALL: {
                return Level.ALL;
            }
        }
        return Level.INFO;
    }

    private static class CounterInterceptor
    implements Interceptor {
        private final Counter counter;
        private final boolean monotonic;

        private CounterInterceptor(Counter counter, boolean monotonic) {
            this.counter = counter;
            this.monotonic = monotonic;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, HandlerInfo handlerInfo) {
            this.counter.inc();
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, HandlerInfo handlerInfo) {
            if (!this.monotonic) {
                this.counter.dec();
            }
        }
    }

    private static class MeterInterceptor
    implements Interceptor {
        private final Meter meter;

        private MeterInterceptor(Meter meter) {
            this.meter = meter;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, HandlerInfo handlerInfo) {
            this.meter.mark();
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, HandlerInfo handlerInfo) {
        }
    }

    private static class TimerInterceptor
    implements Interceptor {
        private final Timer timer;
        private static final String TIMER_CONTEXT = "TIMER_CONTEXT";

        private TimerInterceptor(Timer timer) {
            this.timer = timer;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, HandlerInfo handlerInfo) {
            Timer.Context context = this.timer.start();
            handlerInfo.setAttribute(TIMER_CONTEXT, context);
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, HandlerInfo handlerInfo) {
            Timer.Context context = (Timer.Context)handlerInfo.getAttribute(TIMER_CONTEXT);
            context.stop();
        }
    }
}

