/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportDataHolder;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;

@Component(name="org.wso2.carbon.transport.http.netty.internal.NettyTransportServiceComponent", immediate=true)
public class NettyTransportServiceComponent {
    private static final Logger log = LoggerFactory.getLogger(NettyTransportServiceComponent.class);
    private static final String CHANNEL_ID_KEY = "channel.id";
    private NettyTransportDataHolder dataHolder = NettyTransportDataHolder.getInstance();

    @Reference(name="netty-channel.initializer", service=CarbonNettyServerInitializer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeNettyChannelInitializer")
    protected void addNettyChannelInitializer(CarbonNettyServerInitializer initializer, Map<String, ?> properties) {
        try {
            String channelId = (String)properties.get(CHANNEL_ID_KEY);
            if (channelId == null) {
                throw new IllegalArgumentException("channel.id not specified for ChannelInitializer " + initializer);
            }
            this.dataHolder.addNettyChannelInitializer(channelId, initializer);
        }
        catch (Throwable e) {
            log.error("Cannot add CarbonNettyServerInitializer", e);
        }
    }

    protected void removeNettyChannelInitializer(CarbonNettyServerInitializer initializer, Map<String, ?> properties) {
        String channelId = (String)properties.get(CHANNEL_ID_KEY);
        this.dataHolder.removeNettyChannelInitializer(channelId);
    }
}

