/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal.config;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.wso2.carbon.transport.http.netty.internal.config.TransportsConfiguration;
import org.xml.sax.SAXException;

public class TransportConfigurationBuilder {
    public static final String NETTY_TRANSPORT_CONF = "transports.netty.conf";

    public static TransportsConfiguration build() {
        TransportsConfiguration transportsConfiguration;
        String nettyTransportsConfigFile = System.getProperty(NETTY_TRANSPORT_CONF, "repository" + File.separator + "conf" + File.separator + "transports" + File.separator + "netty-transports.xml");
        File file = new File(nettyTransportsConfigFile);
        if (file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TransportsConfiguration.class});
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource streamSource = new StreamSource();
                streamSource.setInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream("netty-transports.xsd"));
                Schema schema = sf.newSchema(streamSource);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
                transportsConfiguration = (TransportsConfiguration)unmarshaller.unmarshal(file);
            }
            catch (JAXBException | SAXException e) {
                String msg = "Error while loading " + nettyTransportsConfigFile + " configuration file";
                throw new RuntimeException(msg, e);
            }
        } else {
            transportsConfiguration = TransportsConfiguration.getDefault();
        }
        return transportsConfiguration;
    }
}

