/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportDataHolder;
import org.wso2.carbon.transport.http.netty.internal.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.config.Parameter;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;
import org.wso2.carbon.transport.http.netty.listener.NettyServerInitializer;

public class NettyListener
extends CarbonTransport {
    private static final Logger log = LoggerFactory.getLogger(NettyListener.class);
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private String serverState = "STATE_STOPPED";
    private ServerBootstrap bootstrap;
    private ListenerConfiguration nettyConfig;

    public NettyListener(ListenerConfiguration nettyConfig) {
        super(nettyConfig.getId());
        this.nettyConfig = nettyConfig;
        this.bossGroup = new NioEventLoopGroup(nettyConfig.getBossThreadPoolSize());
        this.workerGroup = new NioEventLoopGroup(nettyConfig.getWorkerThreadPoolSize());
    }

    @Override
    public void start() {
        log.info("Starting Netty Http Transport Listener");
        this.startTransport();
    }

    private void startTransport() {
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.option(ChannelOption.SO_BACKLOG, 100);
        this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        this.addChannelInitializer();
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 15000);
        this.bootstrap.option(ChannelOption.SO_SNDBUF, 0x100000);
        this.bootstrap.option(ChannelOption.SO_RCVBUF, 0x100000);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, 0x100000);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, 0x100000);
        this.setupChannelInitializer();
        try {
            this.bootstrap.bind(new InetSocketAddress(this.nettyConfig.getHost(), this.nettyConfig.getPort())).sync();
            this.serverState = "STATE_STARTED";
            log.info("Netty Listener starting on port " + this.nettyConfig.getPort());
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void setupChannelInitializer() {
        List<Parameter> parameters;
        CarbonNettyServerInitializer channelInitializer = NettyTransportDataHolder.getInstance().getChannelInitializer(this.nettyConfig.getId());
        if (channelInitializer != null && (parameters = this.nettyConfig.getParameters()) != null && !parameters.isEmpty()) {
            HashMap<String, String> paramMap = new HashMap<String, String>(parameters.size());
            for (Parameter parameter : parameters) {
                paramMap.put(parameter.getName(), parameter.getValue());
            }
            channelInitializer.setup(paramMap);
        }
    }

    private void addChannelInitializer() {
        NettyServerInitializer handler = new NettyServerInitializer(this.id);
        handler.setSslConfig(this.nettyConfig.getSslConfig());
        this.bootstrap.childHandler(handler);
    }

    @Override
    public void stop() {
        this.serverState = "STATE_TRANSITION";
        log.info("Stopping Netty transport " + this.id + " on port " + this.nettyConfig.getPort());
        this.shutdownEventLoops();
    }

    @Override
    public void beginMaintenance() {
        this.serverState = "STATE_TRANSITION";
        log.info("Putting Netty transport " + this.id + " on port " + this.nettyConfig.getPort() + " into maintenance mode");
        this.shutdownEventLoops();
    }

    @Override
    public void endMaintenance() {
        this.serverState = "STATE_TRANSITION";
        log.info("Ending maintenance mode for Netty transport " + this.id + " running on port " + this.nettyConfig.getPort());
        this.bossGroup = new NioEventLoopGroup(this.nettyConfig.getBossThreadPoolSize());
        this.workerGroup = new NioEventLoopGroup(this.nettyConfig.getWorkerThreadPoolSize());
        this.startTransport();
    }

    public String getState() {
        return this.serverState;
    }

    private void shutdownEventLoops() {
        Future<?> f = this.workerGroup.shutdownGracefully();
        f.addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                Future<?> f = NettyListener.this.bossGroup.shutdownGracefully();
                f.addListener(new GenericFutureListener<Future<Object>>(){

                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        log.info("Netty transport " + NettyListener.this.id + " on port " + NettyListener.this.nettyConfig.getPort() + " stopped successfully");
                        NettyListener.this.serverState = "STATE_STOPPED";
                    }
                });
            }
        });
    }
}

