/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.atomikos;

import com.atomikos.icatch.jta.UserTransactionFactory;
import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionFactory
extends UserTransactionFactory
implements ObjectFactory {
    private static Log log = LogFactory.getLog(TransactionFactory.class);
    private static UserTransactionManager txManager;

    public static void initTxManager() {
        try {
            if (txManager == null) {
                log.info((Object)("Starting Atomikos Transaction Manager " + Configuration.getVersion()));
                txManager = new UserTransactionManager();
            }
            txManager.init();
        }
        catch (SystemException e) {
            log.error((Object)"Error in initializing Atomikos Transaction Manager", (Throwable)e);
        }
    }

    public static void closeTxManager() {
        if (txManager != null) {
            log.info((Object)"Shutting down Atomikos Transaction Manager");
            txManager.close();
            txManager = null;
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        UserTransaction userTx = (UserTransaction)super.getObjectInstance(obj, name, nameCtx, environment);
        return new TransactionManagerWrapper(userTx);
    }

    private class TransactionManagerWrapper
    implements UserTransaction,
    TransactionManager {
        private UserTransaction userTx;

        public TransactionManagerWrapper(UserTransaction userTx) {
            this.userTx = userTx;
        }

        public void begin() throws NotSupportedException, SystemException {
            this.userTx.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.userTx.commit();
        }

        public int getStatus() throws SystemException {
            return this.userTx.getStatus();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.userTx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.userTx.setRollbackOnly();
        }

        public void setTransactionTimeout(int secs) throws SystemException {
            this.userTx.setTransactionTimeout(secs);
        }

        public Transaction getTransaction() throws SystemException {
            return txManager.getTransaction();
        }

        public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
            txManager.resume(tx);
        }

        public Transaction suspend() throws SystemException {
            return txManager.suspend();
        }
    }
}

