/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen;

import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Service;
import org.wso2.codegen.ServiceEndpointsData;
import org.wso2.codegen.WsdlMetaDataFactory;

public class Wsdl20MetaDataFactory
extends WsdlMetaDataFactory {
    private Description wsdlDescription;
    private URL wsdlLocation;

    public Wsdl20MetaDataFactory(String wsdlVersion, String serviceName, MessageContext currentMessageContext) {
        this.wsdlVersion = wsdlVersion;
        this.serviceName = serviceName;
        this.currentMessageContext = currentMessageContext;
    }

    public void printWSDL(OutputStream out, String ip, String serviceContextPath, AxisService axisService) throws AxisFault {
        axisService.printWSDL2(out);
    }

    public void readWSDL(URL wsdlLocation) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        this.wsdlDescription = reader.readWSDL(wsdlLocation.toString());
    }

    public ServiceEndpointsData[] createServiceEndpointsDataArray(URL wsdlLocation) throws AxisFault {
        try {
            this.wsdlLocation = wsdlLocation;
            this.readWSDL(wsdlLocation);
            QName[] serviceBindings = this.getServiceList();
            ServiceEndpointsData[] servicePortData = new ServiceEndpointsData[serviceBindings.length];
            for (int i = 0; i < serviceBindings.length; ++i) {
                ServiceEndpointsData data = new ServiceEndpointsData();
                data.setServiceName(serviceBindings[i].getLocalPart());
                String[] endpoints = this.getEndpointNameList(serviceBindings[i]);
                data.setEndpointNames(endpoints);
                servicePortData[i] = data;
            }
            return servicePortData;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public URL getWSDLLocation() {
        return this.wsdlLocation;
    }

    private String[] getEndpointNameList(QName serviceBinding) {
        ArrayList<String> returnList = new ArrayList<String>();
        Service service = this.wsdlDescription.getService(serviceBinding);
        Endpoint[] endpoints = service.getEndpoints();
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                returnList.add(endpoint.getName().toString());
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    private QName[] getServiceList() {
        ArrayList<QName> returnList = new ArrayList<QName>();
        Service[] services = this.wsdlDescription.getServices();
        if (services != null) {
            for (Service service : services) {
                returnList.add(service.getName());
            }
        }
        return returnList.toArray(new QName[returnList.size()]);
    }
}

