/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.codegen.ServiceEndpointsData;
import org.wso2.codegen.Wsdl11MetaDataFactory;
import org.wso2.codegen.Wsdl20MetaDataFactory;
import org.wso2.codegen.WsdlMetaData;

public abstract class WsdlMetaDataFactory {
    protected String wsdlVersion;
    protected String serviceName;
    protected MessageContext currentMessageContext;
    protected static Log log = LogFactory.getLog(WsdlMetaDataFactory.class);

    public static WsdlMetaDataFactory getFactory(String wsdlVersion, String serviceName, MessageContext currentMessageContext) {
        if (wsdlVersion == null) {
            wsdlVersion = "1.1";
        }
        if (wsdlVersion.equals("1.1")) {
            return new Wsdl11MetaDataFactory(wsdlVersion, serviceName, currentMessageContext);
        }
        if (wsdlVersion.equals("2.0")) {
            return new Wsdl20MetaDataFactory(wsdlVersion, serviceName, currentMessageContext);
        }
        throw new RuntimeException("Unsupported WSDL version " + wsdlVersion);
    }

    public String getWSDLFileURI(String wsdlDir) throws AxisFault {
        if (!new File(wsdlDir).mkdirs()) {
            String s = WsdlMetaDataFactory.class.getName() + " couldn't create " + wsdlDir;
            log.error((Object)s);
            throw new AxisFault(s);
        }
        String wsdlFile = wsdlDir + this.serviceName + ".xml";
        AxisService axisService = this.currentMessageContext.getConfigurationContext().getAxisConfiguration().getService(this.serviceName);
        if (axisService != null) {
            try {
                int seperatorIndex;
                FileOutputStream out = new FileOutputStream(wsdlFile);
                String url = this.currentMessageContext.getTo().getAddress();
                int ipindex = url.indexOf("//");
                String ip = null;
                if (ipindex >= 0 && (seperatorIndex = (ip = url.substring(ipindex + 2, url.length())).indexOf(":")) > 0) {
                    ip = ip.substring(0, seperatorIndex);
                }
                this.printWSDL(out, ip, this.currentMessageContext.getConfigurationContext().getServiceContextPath(), axisService);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                String s = "Could not create WSDL File : ";
                log.error((Object)s, (Throwable)e);
                throw new AxisFault(s + e);
            }
            catch (IOException e) {
                String s = "Could not write to WSDL File : ";
                log.error((Object)s, (Throwable)e);
                throw new AxisFault(s + e);
            }
        } else {
            String s = WsdlMetaDataFactory.class.getName() + " can't find AxisService " + this.serviceName;
            log.error((Object)s);
            throw new AxisFault(s);
        }
        return wsdlFile;
    }

    public UniqueOutputDirInfo generateUniqueCodegenOutputDir() {
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String codegenOutputDir = this.currentMessageContext.getConfigurationContext().getProperty("WORK_DIR") + File.separator + "codegen" + File.separator + uuid + File.separator;
        return new UniqueOutputDirInfo(uuid, codegenOutputDir);
    }

    public UniqueOutputDirInfo generateUniqueDir(String infoDir) {
        UniqueOutputDirInfo uniqueOutputDirInfo = this.generateUniqueCodegenOutputDir();
        String codegenOutputDir = this.generateUniqueCodegenOutputDir().getOutputDir();
        codegenOutputDir = codegenOutputDir + File.separator + infoDir + File.separator;
        return new UniqueOutputDirInfo(uniqueOutputDirInfo.getUuid(), codegenOutputDir);
    }

    public UniqueOutputDirInfo generateUniqueDir(String infoDir, UniqueOutputDirInfo uniqueOutputDirInfo) {
        String dir = uniqueOutputDirInfo.getOutputDir() + File.separator + infoDir + File.separator;
        return new UniqueOutputDirInfo(uniqueOutputDirInfo.uuid, dir);
    }

    protected abstract void printWSDL(OutputStream var1, String var2, String var3, AxisService var4) throws AxisFault;

    protected abstract void readWSDL(URL var1) throws Exception;

    public abstract ServiceEndpointsData[] createServiceEndpointsDataArray(URL var1) throws AxisFault;

    public abstract URL getWSDLLocation();

    public WsdlMetaData createWSDLMetaData(URL wsdlLocation) throws AxisFault {
        WsdlMetaData wsdlMetaData = new WsdlMetaData();
        wsdlMetaData.setWsdlVersion(this.wsdlVersion);
        wsdlMetaData.setServiceEndpointsData(this.createServiceEndpointsDataArray(wsdlLocation));
        return wsdlMetaData;
    }

    protected String getBaseURI(String currentURI) {
        try {
            File file = new File(currentURI);
            if (file.exists()) {
                return file.getCanonicalFile().getParentFile().toURI().toString();
            }
            String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
            return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
        }
        catch (IOException e) {
            return null;
        }
    }

    public class UniqueOutputDirInfo {
        private String uuid;
        private String outputDir;

        protected UniqueOutputDirInfo(String uuid, String outputDir) {
            this.uuid = uuid;
            this.outputDir = outputDir;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getOutputDir() {
            return this.outputDir;
        }
    }
}

