/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.codegen.client.java;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.AntBuildInvoker;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.codegen.WsdlMetaDataFactory;

public class JavaClientGeneratorService {
    private static Log log = LogFactory.getLog(JavaClientGeneratorService.class);

    public String generate(String service, String packageName, String invocationStyle, boolean generateTestCase, String databindingMethod, boolean unpackClasses, String serviceBindingName, String servicePortName, boolean unwrap, String wsdlVersion, String wsdlLocation) {
        File f;
        File[] files;
        WsdlMetaDataFactory wsdlMetaDataFactory = WsdlMetaDataFactory.getFactory(wsdlVersion, service, MessageContext.getCurrentMessageContext());
        WsdlMetaDataFactory.UniqueOutputDirInfo uniqueOutputDirInfo = wsdlMetaDataFactory.generateUniqueCodegenOutputDir();
        String codegenOutputDir = uniqueOutputDirInfo.getOutputDir();
        String uuid = uniqueOutputDirInfo.getUuid();
        System.getProperties().remove("project.base.dir");
        System.getProperties().remove("name");
        System.setProperty("project.base.dir", codegenOutputDir);
        System.setProperty("name", service);
        System.setProperty("axis2.home", System.getProperty("carbon.home") + "/repository");
        WSDL2JavaGenerator generator = new WSDL2JavaGenerator();
        try {
            String[] options = generator.parse(invocationStyle.equals("a"), invocationStyle.equals("s"), false, false, generateTestCase, false, unpackClasses, serviceBindingName, servicePortName, databindingMethod, wsdlLocation, packageName.trim(), "java", codegenOutputDir, unwrap, wsdlVersion);
            CommandLineOptionParser parser = new CommandLineOptionParser(options);
            CodeGenerationEngine codeGenerationEngine = new CodeGenerationEngine(parser);
            codeGenerationEngine.generate();
            File srcDir = new File(codegenOutputDir + File.separator + "src");
            File destDir = new File(codegenOutputDir + File.separator + "build" + File.separator + "classes");
            destDir.mkdirs();
            new FileManipulator().copyDir(srcDir, destDir);
            AntBuildInvoker ant = new AntBuildInvoker(new File(codegenOutputDir + "build.xml"));
            ant.invokeTarget("jar.client");
        }
        catch (Exception e) {
            String msg = "Error occurred during code generation. ";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                msg = msg + e.getCause().getMessage();
            }
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
        Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("file.resource.map", fileResourcesMap);
        }
        if ((files = (f = new File(codegenOutputDir + File.separator + "build" + File.separator + "lib")).listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith("-client.jar");
            }
        })) != null && files[0] != null && files[0].getAbsoluteFile() != null) {
            fileResourcesMap.put(uuid, files[0].getAbsoluteFile().getAbsolutePath());
        }
        return "/filedownload?id=" + uuid;
    }

    private class WSDL2JavaGenerator {
        private WSDL2JavaGenerator() {
        }

        public String[] parse(boolean isAsyncOnly, boolean isSyncOnly, boolean isServerSide, boolean isServerXML, boolean isTestCase, boolean isGenerateAll, boolean isUnpackClasses, String serviceName, String portName, String databindingName, String wsdlURI, String packageName, String selectedLanguage, String outputLocation, boolean isUnwrap, String wsdlVersion) {
            ArrayList<String> argList = new ArrayList<String>();
            String MINUS = "-";
            argList.add(MINUS + "uri");
            argList.add(wsdlURI);
            if (isUnwrap) {
                argList.add(MINUS + "uw");
            }
            if (isAsyncOnly) {
                argList.add(MINUS + "a");
            }
            if (isSyncOnly) {
                argList.add(MINUS + "s");
            }
            if (isServerSide) {
                argList.add(MINUS + "ss");
                if (isServerXML) {
                    argList.add(MINUS + "sd");
                }
                if (isGenerateAll) {
                    argList.add(MINUS + "g");
                }
            }
            if (isTestCase) {
                argList.add(MINUS + "t");
            }
            if (isUnpackClasses) {
                argList.add(MINUS + "u");
            }
            if (packageName != null && packageName.length() != 0) {
                argList.add(MINUS + "p");
                argList.add(packageName);
            }
            argList.add(MINUS + "l");
            argList.add(selectedLanguage);
            argList.add(MINUS + "o");
            argList.add(outputLocation);
            if (databindingName != null && databindingName.length() != 0) {
                argList.add(MINUS + "d");
                argList.add(databindingName);
            }
            if (portName != null && portName.length() != 0) {
                argList.add(MINUS + "pn");
                argList.add(portName);
            }
            if (serviceName != null && serviceName.length() != 0) {
                argList.add(MINUS + "sn");
                argList.add(serviceName);
            }
            if (wsdlVersion != null && wsdlVersion.length() != 0 && wsdlVersion.equals("2.0")) {
                argList.add(MINUS + "wv");
                argList.add("2");
            }
            return argList.toArray(new String[argList.size()]);
        }
    }
}

