/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.ops4j.pax.exam.TestContainerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveExtractor.class);

    private ArchiveExtractor() {
    }

    public static void extract(URL sourceURL, File targetDirectory) throws IOException {
        if ("file".equals(sourceURL.getProtocol())) {
            String file = sourceURL.getFile();
            if (file.endsWith(".zip")) {
                ArchiveExtractor.extractZipDistribution(sourceURL, targetDirectory);
            } else if (file.endsWith(".tar.gz")) {
                ArchiveExtractor.extractTarGzDistribution(sourceURL, targetDirectory);
            } else {
                throw new TestContainerException("Unknown packaging of distribution; only zip or tar.gz could be handled.");
            }
            return;
        }
        if (sourceURL.toExternalForm().endsWith("/zip")) {
            ArchiveExtractor.extractZipDistribution(sourceURL, targetDirectory);
        } else if (sourceURL.toExternalForm().endsWith("/tar.gz")) {
            ArchiveExtractor.extractTarGzDistribution(sourceURL, targetDirectory);
        } else {
            throw new TestContainerException("Unknown packaging; only zip or tar.gz could be handled. URL was " + sourceURL);
        }
    }

    public static void extract(Path path, File targetDirectory) throws IOException {
        if (!path.toString().endsWith(".zip")) {
            throw new TestContainerException("Unknown packaging of distribution; only zip can be handled.");
        }
        ArchiveExtractor.extract((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new FileInputStream(path.toFile())), targetDirectory);
    }

    private static void extractTarGzDistribution(URL sourceDistribution, File targetDirectory) throws IOException {
        File uncompressedFile = File.createTempFile("uncompressedTarGz-", ".tar");
        ArchiveExtractor.extractGzArchive(sourceDistribution, uncompressedFile);
        ArchiveExtractor.extract((ArchiveInputStream)new TarArchiveInputStream((InputStream)new FileInputStream(uncompressedFile)), targetDirectory);
        FileUtils.forceDelete((File)uncompressedFile);
    }

    private static void extractZipDistribution(URL sourceDistribution, File targetDirectory) throws IOException {
        ArchiveExtractor.extract((ArchiveInputStream)new ZipArchiveInputStream(sourceDistribution.openStream()), targetDirectory);
    }

    private static void extractGzArchive(URL sourceDistribution, File tar) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(sourceDistribution.openStream());
             FileOutputStream out = new FileOutputStream(tar);
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);){
            int n;
            byte[] buffer = new byte[1000];
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ArchiveInputStream is, File targetDir) throws IOException {
        try {
            if (targetDir.exists()) {
                FileUtils.forceDelete((File)targetDir);
            }
            ArchiveExtractor.createDirectory(targetDir);
            ArchiveEntry entry = is.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                name = name.substring(name.indexOf("/") + 1);
                File file = new File(targetDir, name);
                if (entry.isDirectory()) {
                    ArchiveExtractor.createDirectory(file);
                } else {
                    ArchiveExtractor.createDirectory(file.getParentFile());
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                }
                entry = is.getNextEntry();
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Error occurred while closing the stream", (Throwable)e);
            }
        }
    }

    private static void createDirectory(File directory) {
        boolean isCreated = true;
        if (!directory.exists()) {
            isCreated = directory.mkdirs();
        }
        if (!isCreated) {
            throw new TestContainerException("Couldn't create the directory: " + directory.toString());
        }
    }
}

