/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container.options;

import java.nio.file.Path;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.wso2.carbon.container.options.CarbonDistributionBaseOption;
import org.wso2.carbon.container.options.CopyFileOption;
import org.wso2.carbon.container.options.CopyOSGiLibBundleOption;
import org.wso2.carbon.container.options.DebugOption;
import org.wso2.carbon.container.options.KeepDirectoryOption;

public class CarbonDistributionOption {
    private CarbonDistributionOption() {
    }

    public static CarbonDistributionBaseOption carbonDistribution(MavenUrlReference mavenUrlReference) {
        return new CarbonDistributionBaseOption().distributionMavenURL(mavenUrlReference);
    }

    public static CarbonDistributionBaseOption carbonDistribution(Path path) {
        if (path.toString().endsWith("zip")) {
            return new CarbonDistributionBaseOption().distributionZipPath(path);
        }
        return new CarbonDistributionBaseOption().distributionDirectoryPath(path);
    }

    public static Option copyFile(Path sourcePath, Path destinationPath) {
        return new CopyFileOption(sourcePath, destinationPath);
    }

    public static Option copyOSGiLibBundle(MavenArtifactUrlReference mavenArtifactUrlReference) {
        return new CopyOSGiLibBundleOption(mavenArtifactUrlReference);
    }

    public static Option keepDirectory() {
        return new KeepDirectoryOption();
    }

    public static Option debug() {
        return new DebugOption();
    }

    public static Option debug(int port) {
        return new DebugOption(port);
    }
}

