/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.ops4j.net.FreePort;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.container.remote.RBCRemoteTarget;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.ValueOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.container.ArchiveExtractor;
import org.wso2.carbon.container.options.CarbonDistributionBaseOption;
import org.wso2.carbon.container.options.CopyFileOption;
import org.wso2.carbon.container.options.CopyOSGiLibBundleOption;
import org.wso2.carbon.container.options.DebugOption;
import org.wso2.carbon.container.options.KeepDirectoryOption;
import org.wso2.carbon.container.runner.CarbonRunner;
import org.wso2.carbon.container.runner.Runner;

public class CarbonTestContainer
implements TestContainer {
    private static final Logger logger = LoggerFactory.getLogger(CarbonTestContainer.class);
    private static final String CARBON_TEST_CONTAINER = "CarbonTestContainer";
    private static final String EXAM_INJECT_PROPERTY = "pax.exam.inject";
    private static final String LIB_DIRECTORY = "lib";
    private final Runner runner;
    private final ExamSystem system;
    private CarbonDistributionBaseOption carbonHomeDirectoryOption;
    private RBCRemoteTarget target;
    private Path targetDirectory;
    private Registry registry;
    private boolean started;

    public CarbonTestContainer(ExamSystem system, CarbonDistributionBaseOption carbonHomeDirectoryOption) {
        this.carbonHomeDirectoryOption = carbonHomeDirectoryOption;
        this.system = system;
        this.runner = new CarbonRunner();
    }

    public synchronized TestContainer start() {
        if (this.carbonHomeDirectoryOption.getDistributionDirectoryPath() == null && this.carbonHomeDirectoryOption.getDistributionMavenURL() == null && this.carbonHomeDirectoryOption.getDistributionZipPath() == null) {
            throw new TestContainerException("Distribution path need to be set.");
        }
        try {
            Object sourceDistribution;
            String name = this.system.createID(CARBON_TEST_CONTAINER);
            FreePort freePort = new FreePort(21000, 21099);
            int port = freePort.getPort();
            logger.debug("using RMI registry at port {}" + name, (Object)port);
            this.registry = LocateRegistry.createRegistry(port);
            String host = InetAddress.getLocalHost().getHostName();
            ExamSystem subsystem = this.system.fork(CoreOptions.options((Option[])new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.host").value(host), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.port").value(Integer.toString(port)), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.name").value(name), CoreOptions.systemProperty((String)EXAM_INJECT_PROPERTY).value("true")}));
            this.target = new RBCRemoteTarget(name, Integer.valueOf(port), subsystem.getTimeout());
            System.setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
            this.addRepositories();
            this.targetDirectory = this.retrieveFinalTargetDirectory();
            if (this.carbonHomeDirectoryOption.getDistributionMavenURL() != null) {
                sourceDistribution = new URL(this.carbonHomeDirectoryOption.getDistributionMavenURL().getURL());
                ArchiveExtractor.extract((URL)sourceDistribution, this.targetDirectory.toFile());
            } else if (this.carbonHomeDirectoryOption.getDistributionZipPath() != null) {
                sourceDistribution = this.carbonHomeDirectoryOption.getDistributionZipPath();
                ArchiveExtractor.extract((Path)sourceDistribution, this.targetDirectory.toFile());
            } else if (this.carbonHomeDirectoryOption.getDistributionDirectoryPath() != null) {
                Path sourceDirectory = this.carbonHomeDirectoryOption.getDistributionDirectoryPath();
                FileUtils.copyDirectory((File)sourceDirectory.toFile(), (File)this.targetDirectory.toFile());
            }
            this.copyOSGiLibBundles(this.targetDirectory);
            this.copyFiles(this.targetDirectory);
            Path carbonBin = this.targetDirectory.resolve("bin");
            Path runtimeBin = this.carbonHomeDirectoryOption.getCarbonRuntimeName() != null ? this.targetDirectory.resolve("wso2").resolve(this.carbonHomeDirectoryOption.getCarbonRuntimeName()).resolve("bin") : this.targetDirectory.resolve("wso2").resolve("default").resolve("bin");
            this.makeFilesInBinExec(carbonBin.toFile());
            this.makeFilesInBinExec(runtimeBin.toFile());
            ArrayList<String> options = new ArrayList<String>();
            String[] environment = new String[]{};
            this.setupSystemProperties(options, subsystem);
            DebugOption debugOption = (DebugOption)this.system.getSingleOption(DebugOption.class);
            if (debugOption != null) {
                options.add(debugOption.getDebugConfiguration());
            }
            if (this.carbonHomeDirectoryOption.getCarbonRuntimeName() != null) {
                this.runner.exec(environment, this.targetDirectory.resolve("wso2").resolve(this.carbonHomeDirectoryOption.getCarbonRuntimeName()), options);
            } else {
                this.runner.exec(environment, this.targetDirectory.resolve("wso2").resolve("default"), options);
            }
            logger.debug("Wait for test container to finish its initialization " + subsystem.getTimeout());
            this.waitForState(0L, 32, subsystem.getTimeout());
            this.started = true;
        }
        catch (IOException e) {
            throw new TestContainerException("Problem starting container", (Throwable)e);
        }
        return this;
    }

    private void addRepositories() {
        RepositoryOption[] repositories = (RepositoryOption[])this.system.getOptions(RepositoryOption.class);
        if (repositories.length != 0) {
            System.setProperty("org.ops4j.pax.url.mvn.repositories", this.buildString((ValueOption<?>[])repositories));
        }
    }

    private void copyOSGiLibBundles(Path carbonHome) {
        Path targetDirectory = carbonHome.resolve(LIB_DIRECTORY);
        Arrays.asList(this.system.getOptions(CopyOSGiLibBundleOption.class)).forEach(option -> {
            try {
                this.copyReferencedArtifactsToDeployDirectory(option.getMavenArtifactUrlReference().getURL(), targetDirectory);
            }
            catch (IOException e) {
                throw new TestContainerException(String.format("Error while copying artifacts to lib", new Object[0]), (Throwable)e);
            }
        });
    }

    private void copyReferencedArtifactsToDeployDirectory(String url, Path targetDirectory) throws IOException {
        File target = this.createUnique(url, targetDirectory.toFile());
        FileUtils.copyURLToFile((URL)new URL(url), (File)target);
    }

    private File createUnique(String url, File deploy) {
        String prefix = UUID.randomUUID().toString();
        String fileName = new File(url).getName();
        return new File(deploy, prefix + "_" + fileName + ".jar");
    }

    private void copyFiles(Path carbonHome) {
        Arrays.asList(this.system.getOptions(CopyFileOption.class)).forEach(option -> {
            try {
                Files.copy(option.getSourcePath(), carbonHome.resolve(option.getDestinationPath()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new TestContainerException("Error while copying configuration files", (Throwable)e);
            }
        });
    }

    private void setupSystemProperties(List<String> options, ExamSystem examSystem) throws IOException {
        Arrays.asList(examSystem.getOptions(SystemPropertyOption.class)).forEach(systemPropertyOption -> {
            String property = String.format("-D%s=%s", systemPropertyOption.getKey(), systemPropertyOption.getValue());
            options.add(property);
        });
    }

    private void makeFilesInBinExec(File carbonBin) {
        if (!carbonBin.exists()) {
            return;
        }
        File[] files = carbonBin.listFiles();
        if (files != null) {
            Arrays.asList(files).forEach(file -> file.setExecutable(true));
        }
    }

    private Path retrieveFinalTargetDirectory() throws IOException {
        boolean isCreated;
        Path unpackDirectory = this.carbonHomeDirectoryOption.getUnpackDirectory();
        if (unpackDirectory == null) {
            unpackDirectory = Paths.get("target", UUID.randomUUID().toString());
        }
        boolean bl = isCreated = unpackDirectory.toFile().exists() || unpackDirectory.toFile().mkdir();
        if (!isCreated) {
            throw new TestContainerException("Couldn't create the directory: " + unpackDirectory.toFile().toString());
        }
        return unpackDirectory;
    }

    private boolean shouldDeleteRuntime() {
        boolean deleteRuntime = true;
        KeepDirectoryOption keepDirectoryOption = (KeepDirectoryOption)this.system.getSingleOption(KeepDirectoryOption.class);
        if (keepDirectoryOption != null) {
            deleteRuntime = false;
        }
        return deleteRuntime;
    }

    private String buildString(ValueOption<?>[] options) {
        return this.buildString(new String[0], options, new String[0]);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options, String[] append) {
        StringBuilder builder = new StringBuilder();
        Arrays.asList(prepend).forEach(s -> {
            builder.append((String)s);
            builder.append(",");
        });
        Arrays.asList(options).forEach(option -> {
            builder.append(option.getValue());
            builder.append(",");
        });
        Arrays.asList(append).forEach(s -> {
            builder.append((String)s);
            builder.append(",");
        });
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    public synchronized TestContainer stop() {
        block12: {
            logger.debug("Shutting down the test container.");
            try {
                if (this.started) {
                    this.target.stop();
                    RemoteBundleContextClient remoteBundleContextClient = this.target.getClientRBC();
                    if (remoteBundleContextClient != null) {
                        remoteBundleContextClient.stop();
                    }
                    this.runner.shutdown();
                    try {
                        UnicastRemoteObject.unexportObject(this.registry, true);
                        break block12;
                    }
                    catch (NoSuchObjectException exc) {
                        throw new TestContainerException((Throwable)exc);
                    }
                }
                throw new TestContainerException("Container never started.");
            }
            finally {
                this.started = false;
                this.target = null;
                if (this.shouldDeleteRuntime()) {
                    this.system.clear();
                    try {
                        FileUtils.forceDelete((File)this.targetDirectory.toFile());
                    }
                    catch (IOException e) {
                        this.forceCleanup();
                    }
                }
            }
        }
        return this;
    }

    private void forceCleanup() {
        try {
            FileUtils.forceDeleteOnExit((File)this.targetDirectory.toFile());
        }
        catch (IOException e) {
            logger.error("Error occured when deleting the Directory.", (Throwable)e);
        }
    }

    private synchronized void waitForState(long bundleId, int state, RelativeTimeout timeout) {
        this.target.getClientRBC().waitForState(bundleId, state, timeout);
    }

    public synchronized void call(TestAddress address) {
        this.target.call(address);
    }

    public synchronized long install(InputStream stream) {
        return this.install("local", stream);
    }

    public synchronized long install(String location, InputStream stream) {
        return this.target.install(location, stream);
    }

    public synchronized long installProbe(InputStream stream) {
        return this.target.installProbe(stream);
    }

    public synchronized void uninstallProbe() {
        this.target.uninstallProbe();
    }

    public String toString() {
        return CARBON_TEST_CONTAINER;
    }
}

