/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container.runner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.ops4j.io.Pipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.container.runner.CommandLineBuilder;

public class InternalRunner {
    private static final Logger logger = LoggerFactory.getLogger(InternalRunner.class);
    private final Object shutdownHookMonitor = new Object();
    private final Object frameworkProcessMonitor = new Object();
    private Process frameworkProcess;
    private Thread shutdownHook;

    public synchronized void exec(CommandLineBuilder commandLine, String[] envOptions) {
        if (this.frameworkProcess != null) {
            throw new IllegalStateException("Server is already started");
        }
        try {
            this.frameworkProcess = Runtime.getRuntime().exec(commandLine.toArray(), this.createEnvironmentVars(envOptions), null);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not start up the process", e);
        }
        this.shutdownHook = this.createShutdownHook(this.frameworkProcess);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.waitForExit();
    }

    private String[] createEnvironmentVars(String[] envOptions) {
        ArrayList env = new ArrayList();
        Map<String, String> getenv = System.getenv();
        env.addAll(getenv.keySet().stream().map(key -> key + "=" + (String)getenv.get(key)).collect(Collectors.toList()));
        if (envOptions != null) {
            Collections.addAll(env, envOptions);
        }
        return env.toArray(new String[env.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        block6: {
            try {
                if (this.shutdownHook == null) break block6;
                Object object = this.shutdownHookMonitor;
                synchronized (object) {
                    if (this.shutdownHook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.frameworkProcess = null;
                        this.shutdownHook.start();
                        this.shutdownHook = null;
                    }
                }
            }
            catch (IllegalStateException ignore) {
                logger.error("Already started the process.", (Throwable)ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExit() {
        if (this.shutdownHook != null) {
            Object object = this.shutdownHookMonitor;
            synchronized (object) {
                if (this.shutdownHook != null) {
                    Object object2 = this.frameworkProcessMonitor;
                    synchronized (object2) {
                        try {
                            if (this.frameworkProcess != null) {
                                this.frameworkProcess.waitFor();
                            }
                            this.shutdown();
                        }
                        catch (Throwable e) {
                            this.shutdown();
                        }
                    }
                }
            }
        }
    }

    private Thread createShutdownHook(Process process) {
        Pipe errPipe = new Pipe(process.getErrorStream(), (OutputStream)System.err).start("Error pipe");
        Pipe outPipe = new Pipe(process.getInputStream(), (OutputStream)System.out).start("Out pipe");
        Pipe inPipe = new Pipe(process.getOutputStream(), System.in).start("In pipe");
        return new Thread(() -> {
            inPipe.stop();
            outPipe.stop();
            errPipe.stop();
            try {
                process.destroy();
            }
            catch (Exception e) {
                logger.error("Already shutting down the process.", (Throwable)e);
            }
        });
    }
}

