/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.container.CarbonTestContainer;
import org.wso2.carbon.container.options.CarbonDistributionBaseOption;

public class CarbonContainerFactory
implements TestContainerFactory {
    private static final String DEFAULT_DISTRIBUTION = "org.wso2.carbon.test.default.distribution";
    private static final Logger logger = LoggerFactory.getLogger(TestContainerFactory.class);

    public TestContainer[] create(ExamSystem system) {
        List<TestContainer> containers;
        if (((CarbonDistributionBaseOption[])system.getOptions(CarbonDistributionBaseOption.class)).length > 1) {
            logger.warn("Multiple distribution options are specified in the configuration!!!");
        }
        if ((containers = Arrays.stream(system.getOptions(CarbonDistributionBaseOption.class)).map(option -> new CarbonTestContainer(system, (CarbonDistributionBaseOption)option)).collect(Collectors.toList())).isEmpty()) {
            containers.add(new CarbonTestContainer(system, this.getDefaultConfiguration()));
        }
        return containers.toArray(new TestContainer[containers.size()]);
    }

    private CarbonDistributionBaseOption getDefaultConfiguration() {
        String defaultDistribution = System.getProperty(DEFAULT_DISTRIBUTION);
        if (defaultDistribution == null) {
            throw new TestContainerException("Default distribution is not specified.");
        }
        String[] distribution = defaultDistribution.split(":");
        if (distribution.length < 3) {
            return new CarbonDistributionBaseOption().distributionMavenURL((MavenUrlReference)CoreOptions.maven().groupId(distribution[0]).artifactId(distribution[1]).versionAsInProject().type("zip"));
        }
        return new CarbonDistributionBaseOption().distributionMavenURL((MavenUrlReference)CoreOptions.maven().groupId(distribution[0]).artifactId(distribution[1]).version(distribution[2]).type("zip"));
    }
}

